/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

final class OpenFollowerIndexStep
extends AsyncActionStep {
    static final String NAME = "open-follower-index";

    OpenFollowerIndexStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ClusterState currentClusterState, ClusterStateObserver observer, AsyncActionStep.Listener listener) {
        if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
            OpenIndexRequest request = (OpenIndexRequest)new OpenIndexRequest(new String[]{indexMetadata.getIndex().getName()}).masterNodeTimeout(OpenFollowerIndexStep.getMasterTimeout(currentClusterState));
            this.getClient().admin().indices().open(request, ActionListener.wrap(r -> {
                assert (r.isAcknowledged()) : "open index response is not acknowledged";
                listener.onResponse(true);
            }, listener::onFailure));
        } else {
            listener.onResponse(true);
        }
    }
}

