/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import com.carrotsearch.hppc.cursors.IntObjectCursor;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.RolloverAction;
import org.elasticsearch.xpack.core.ilm.Step;

public class WaitForActiveShardsStep
extends ClusterStateWaitStep {
    public static final String NAME = "wait-for-active-shards";
    private static final Logger logger = LogManager.getLogger(WaitForActiveShardsStep.class);

    WaitForActiveShardsStep(Step.StepKey key, Step.StepKey nextStepKey) {
        super(key, nextStepKey);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public ClusterStateWaitStep.Result isConditionMet(Index index, ClusterState clusterState) {
        String waitForActiveShardsSettingValue;
        String rolledIndexName;
        Metadata metadata = clusterState.metadata();
        IndexMetadata originalIndexMeta = metadata.index(index);
        if (originalIndexMeta == null) {
            String errorMessage = String.format(Locale.ROOT, "[%s] lifecycle action for index [%s] executed but index no longer exists", this.getKey().getAction(), index.getName());
            logger.debug(errorMessage);
            return new ClusterStateWaitStep.Result(false, new Info(errorMessage));
        }
        boolean indexingComplete = (Boolean)LifecycleSettings.LIFECYCLE_INDEXING_COMPLETE_SETTING.get(originalIndexMeta.getSettings());
        if (indexingComplete) {
            String message = String.format(Locale.ROOT, "index [%s] has lifecycle complete set, skipping [%s]", originalIndexMeta.getIndex().getName(), NAME);
            logger.trace(message);
            return new ClusterStateWaitStep.Result(true, new Info(message));
        }
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(index.getName());
        if (indexAbstraction.getParentDataStream() != null) {
            DataStream dataStream = indexAbstraction.getParentDataStream().getDataStream();
            IndexAbstraction dataStreamAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(dataStream.getName());
            assert (dataStreamAbstraction != null) : dataStream.getName() + " datastream is not present in the metadata indices lookup";
            IndexMetadata rolledIndexMeta = dataStreamAbstraction.getWriteIndex();
            if (rolledIndexMeta == null) {
                return WaitForActiveShardsStep.getErrorResultOnNullMetadata(this.getKey(), index);
            }
            rolledIndexName = rolledIndexMeta.getIndex().getName();
            waitForActiveShardsSettingValue = rolledIndexMeta.getSettings().get(IndexMetadata.SETTING_WAIT_FOR_ACTIVE_SHARDS.getKey());
        } else {
            String rolloverAlias = (String)RolloverAction.LIFECYCLE_ROLLOVER_ALIAS_SETTING.get(originalIndexMeta.getSettings());
            if (Strings.isNullOrEmpty((String)rolloverAlias)) {
                throw new IllegalStateException("setting [index.lifecycle.rollover_alias] is not set on index [" + originalIndexMeta.getIndex().getName() + "]");
            }
            IndexAbstraction aliasAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(rolloverAlias);
            assert (aliasAbstraction.getType() == IndexAbstraction.Type.ALIAS) : rolloverAlias + " must be an alias but it is not";
            IndexMetadata aliasWriteIndex = aliasAbstraction.getWriteIndex();
            if (aliasWriteIndex != null) {
                rolledIndexName = aliasWriteIndex.getIndex().getName();
                waitForActiveShardsSettingValue = aliasWriteIndex.getSettings().get(IndexMetadata.SETTING_WAIT_FOR_ACTIVE_SHARDS.getKey());
            } else {
                List indices = aliasAbstraction.getIndices();
                int maxIndexCounter = -1;
                IndexMetadata rolledIndexMeta = null;
                for (IndexMetadata indexMetadata : indices) {
                    int indexNameCounter = IndexMetadata.parseIndexNameCounter((String)indexMetadata.getIndex().getName());
                    if (maxIndexCounter >= indexNameCounter) continue;
                    maxIndexCounter = indexNameCounter;
                    rolledIndexMeta = indexMetadata;
                }
                if (rolledIndexMeta == null) {
                    return WaitForActiveShardsStep.getErrorResultOnNullMetadata(this.getKey(), index);
                }
                rolledIndexName = rolledIndexMeta.getIndex().getName();
                waitForActiveShardsSettingValue = rolledIndexMeta.getSettings().get("index.write.wait_for_active_shards");
            }
        }
        ActiveShardCount activeShardCount = ActiveShardCount.parseString((String)waitForActiveShardsSettingValue);
        boolean enoughShardsActive = activeShardCount.enoughShardsActive(clusterState, new String[]{rolledIndexName});
        IndexRoutingTable indexRoutingTable = clusterState.routingTable().index(rolledIndexName);
        int currentActiveShards = 0;
        for (IntObjectCursor shardRouting : indexRoutingTable.getShards()) {
            currentActiveShards += ((IndexShardRoutingTable)shardRouting.value).activeShards().size();
        }
        return new ClusterStateWaitStep.Result(enoughShardsActive, new ActiveShardsInfo(currentActiveShards, activeShardCount.toString(), enoughShardsActive));
    }

    private static ClusterStateWaitStep.Result getErrorResultOnNullMetadata(Step.StepKey key, Index originalIndex) {
        String errorMessage = String.format(Locale.ROOT, "unable to find the index that was rolled over from [%s] as part of lifecycle action [%s]", originalIndex.getName(), key.getAction());
        logger.debug(errorMessage);
        return new ClusterStateWaitStep.Result(false, new Info(errorMessage));
    }

    static final class Info
    implements ToXContentObject {
        private final String message;
        static final ParseField MESSAGE = new ParseField("message", new String[0]);

        Info(String message) {
            this.message = message;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(MESSAGE.getPreferredName(), this.message);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Info info = (Info)o;
            return Objects.equals(this.message, info.message);
        }

        public int hashCode() {
            return Objects.hash(this.message);
        }
    }

    static final class ActiveShardsInfo
    implements ToXContentObject {
        private final long currentActiveShardsCount;
        private final String targetActiveShardsCount;
        private final boolean enoughShardsActive;
        private final String message;
        static final ParseField CURRENT_ACTIVE_SHARDS_COUNT = new ParseField("current_active_shards_count", new String[0]);
        static final ParseField TARGET_ACTIVE_SHARDS_COUNT = new ParseField("target_active_shards_count", new String[0]);
        static final ParseField ENOUGH_SHARDS_ACTIVE = new ParseField("enough_shards_active", new String[0]);
        static final ParseField MESSAGE = new ParseField("message", new String[0]);

        ActiveShardsInfo(long currentActiveShardsCount, String targetActiveShardsCount, boolean enoughShardsActive) {
            this.currentActiveShardsCount = currentActiveShardsCount;
            this.targetActiveShardsCount = targetActiveShardsCount;
            this.enoughShardsActive = enoughShardsActive;
            this.message = enoughShardsActive ? "the target of [" + targetActiveShardsCount + "] are active. Don't need to wait anymore" : "waiting for [" + targetActiveShardsCount + "] shards to become active, but only [" + currentActiveShardsCount + "] are active";
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(MESSAGE.getPreferredName(), this.message);
            builder.field(CURRENT_ACTIVE_SHARDS_COUNT.getPreferredName(), this.currentActiveShardsCount);
            builder.field(TARGET_ACTIVE_SHARDS_COUNT.getPreferredName(), this.targetActiveShardsCount);
            builder.field(ENOUGH_SHARDS_ACTIVE.getPreferredName(), this.enoughShardsActive);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActiveShardsInfo info = (ActiveShardsInfo)o;
            return this.currentActiveShardsCount == info.currentActiveShardsCount && this.enoughShardsActive == info.enoughShardsActive && Objects.equals(this.targetActiveShardsCount, info.targetActiveShardsCount) && Objects.equals(this.message, info.message);
        }

        public int hashCode() {
            return Objects.hash(this.currentActiveShardsCount, this.targetActiveShardsCount, this.enoughShardsActive, this.message);
        }
    }
}

