/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class DeleteCalendarAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteCalendarAction INSTANCE = new DeleteCalendarAction();
    public static final String NAME = "cluster:admin/xpack/ml/calendars/delete";

    private DeleteCalendarAction() {
        super(NAME, AcknowledgedResponse::new);
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, AcknowledgedResponse> {
        public RequestBuilder(ElasticsearchClient client, DeleteCalendarAction action) {
            super(client, (ActionType)action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private String calendarId;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.calendarId = in.readString();
        }

        public Request() {
        }

        public Request(String calendarId) {
            this.calendarId = ExceptionsHelper.requireNonNull(calendarId, Calendar.ID.getPreferredName());
        }

        public String getCalendarId() {
            return this.calendarId;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.calendarId);
        }

        public int hashCode() {
            return Objects.hash(this.calendarId);
        }

        public boolean equals(Object obj) {
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.calendarId, other.calendarId);
        }
    }
}

