/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.ml.action.JobTaskRequest;
import org.elasticsearch.xpack.core.ml.job.config.JobUpdate;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.job.config.ModelPlotConfig;
import org.elasticsearch.xpack.core.ml.job.config.PerPartitionCategorizationConfig;

public class UpdateProcessAction
extends ActionType<Response> {
    public static final UpdateProcessAction INSTANCE = new UpdateProcessAction();
    public static final String NAME = "cluster:internal/xpack/ml/job/update/process";

    private UpdateProcessAction() {
        super(NAME, Response::new);
    }

    public static class Request
    extends JobTaskRequest<Request> {
        private ModelPlotConfig modelPlotConfig;
        private PerPartitionCategorizationConfig perPartitionCategorizationConfig;
        private List<JobUpdate.DetectorUpdate> detectorUpdates;
        private MlFilter filter;
        private boolean updateScheduledEvents = false;

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.modelPlotConfig = (ModelPlotConfig)in.readOptionalWriteable(ModelPlotConfig::new);
            if (in.getVersion().onOrAfter(Version.V_7_9_0)) {
                this.perPartitionCategorizationConfig = (PerPartitionCategorizationConfig)in.readOptionalWriteable(PerPartitionCategorizationConfig::new);
            }
            if (in.readBoolean()) {
                this.detectorUpdates = in.readList(JobUpdate.DetectorUpdate::new);
            }
            if (in.getVersion().onOrAfter(Version.V_6_2_0)) {
                this.filter = (MlFilter)in.readOptionalWriteable(MlFilter::new);
                this.updateScheduledEvents = in.readBoolean();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalWriteable((Writeable)this.modelPlotConfig);
            if (out.getVersion().onOrAfter(Version.V_7_9_0)) {
                out.writeOptionalWriteable((Writeable)this.perPartitionCategorizationConfig);
            }
            boolean hasDetectorUpdates = this.detectorUpdates != null;
            out.writeBoolean(hasDetectorUpdates);
            if (hasDetectorUpdates) {
                out.writeList(this.detectorUpdates);
            }
            if (out.getVersion().onOrAfter(Version.V_6_2_0)) {
                out.writeOptionalWriteable((Writeable)this.filter);
                out.writeBoolean(this.updateScheduledEvents);
            }
        }

        public Request(String jobId, ModelPlotConfig modelPlotConfig, PerPartitionCategorizationConfig perPartitionCategorizationConfig, List<JobUpdate.DetectorUpdate> detectorUpdates, MlFilter filter, boolean updateScheduledEvents) {
            super(jobId);
            this.modelPlotConfig = modelPlotConfig;
            this.perPartitionCategorizationConfig = perPartitionCategorizationConfig;
            this.detectorUpdates = detectorUpdates;
            this.filter = filter;
            this.updateScheduledEvents = updateScheduledEvents;
        }

        public ModelPlotConfig getModelPlotConfig() {
            return this.modelPlotConfig;
        }

        public PerPartitionCategorizationConfig getPerPartitionCategorizationConfig() {
            return this.perPartitionCategorizationConfig;
        }

        public List<JobUpdate.DetectorUpdate> getDetectorUpdates() {
            return this.detectorUpdates;
        }

        public MlFilter getFilter() {
            return this.filter;
        }

        public boolean isUpdateScheduledEvents() {
            return this.updateScheduledEvents;
        }

        public int hashCode() {
            return Objects.hash(this.getJobId(), this.modelPlotConfig, this.perPartitionCategorizationConfig, this.detectorUpdates, this.filter, this.updateScheduledEvents);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.getJobId(), other.getJobId()) && Objects.equals(this.modelPlotConfig, other.modelPlotConfig) && Objects.equals(this.perPartitionCategorizationConfig, other.perPartitionCategorizationConfig) && Objects.equals(this.detectorUpdates, other.detectorUpdates) && Objects.equals(this.filter, other.filter) && Objects.equals(this.updateScheduledEvents, other.updateScheduledEvents);
        }
    }

    public static class Response
    extends BaseTasksResponse
    implements StatusToXContentObject,
    Writeable {
        private final boolean isUpdated;

        public Response() {
            super(null, null);
            this.isUpdated = true;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.isUpdated = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.isUpdated);
        }

        public boolean isUpdated() {
            return this.isUpdated;
        }

        public RestStatus status() {
            return RestStatus.ACCEPTED;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("updated", this.isUpdated);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hashCode(this.isUpdated);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return this.isUpdated == other.isUpdated;
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response> {
        RequestBuilder(ElasticsearchClient client, UpdateProcessAction action) {
            super(client, (ActionType)action, (ActionRequest)new Request());
        }
    }
}

