/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetricResult;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationParameters;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public interface Evaluation
extends ToXContentObject,
NamedWriteable {
    public String getName();

    public String getActualField();

    public String getPredictedField();

    public List<? extends EvaluationMetric> getMetrics();

    default public <T extends EvaluationMetric> List<T> initMetrics(@Nullable List<T> parsedMetrics, Supplier<List<T>> defaultMetricsSupplier) {
        List<T> metrics;
        List<T> list = metrics = parsedMetrics == null ? defaultMetricsSupplier.get() : new ArrayList<T>(parsedMetrics);
        if (metrics.isEmpty()) {
            throw ExceptionsHelper.badRequestException("[{}] must have one or more metrics", this.getName());
        }
        Collections.sort(metrics, Comparator.comparing(EvaluationMetric::getName));
        return metrics;
    }

    default public SearchSourceBuilder buildSearch(EvaluationParameters parameters, QueryBuilder userProvidedQueryBuilder) {
        Objects.requireNonNull(userProvidedQueryBuilder);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.existsQuery((String)this.getActualField())).filter((QueryBuilder)QueryBuilders.existsQuery((String)this.getPredictedField())).filter(userProvidedQueryBuilder);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0).query((QueryBuilder)boolQuery);
        for (EvaluationMetric evaluationMetric : this.getMetrics()) {
            Tuple<List<AggregationBuilder>, List<PipelineAggregationBuilder>> aggs = evaluationMetric.aggs(parameters, this.getActualField(), this.getPredictedField());
            ((List)aggs.v1()).forEach(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).aggregation(arg_0));
            ((List)aggs.v2()).forEach(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).aggregation(arg_0));
        }
        return searchSourceBuilder;
    }

    default public void process(SearchResponse searchResponse) {
        Objects.requireNonNull(searchResponse);
        if (searchResponse.getHits().getTotalHits().value == 0L) {
            throw ExceptionsHelper.badRequestException("No documents found containing both [{}, {}] fields", this.getActualField(), this.getPredictedField());
        }
        for (EvaluationMetric evaluationMetric : this.getMetrics()) {
            evaluationMetric.process(searchResponse.getAggregations());
        }
    }

    default public boolean hasAllResults() {
        return this.getMetrics().stream().map(EvaluationMetric::getResult).allMatch(Optional::isPresent);
    }

    default public List<EvaluationMetricResult> getResults() {
        return this.getMetrics().stream().map(EvaluationMetric::getResult).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

