/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.stats.classification;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.dataframe.stats.common.FoldValues;

public class ValidationLoss
implements ToXContentObject,
Writeable {
    public static final ParseField LOSS_TYPE = new ParseField("loss_type", new String[0]);
    public static final ParseField FOLD_VALUES = new ParseField("fold_values", new String[0]);
    private final String lossType;
    private final List<FoldValues> foldValues;

    public static ValidationLoss fromXContent(XContentParser parser, boolean ignoreUnknownFields) {
        return (ValidationLoss)ValidationLoss.createParser(ignoreUnknownFields).apply(parser, null);
    }

    private static ConstructingObjectParser<ValidationLoss, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser("classification_validation_loss", ignoreUnknownFields, a -> new ValidationLoss((String)a[0], (List)a[1]));
        parser.declareString(ConstructingObjectParser.constructorArg(), LOSS_TYPE);
        parser.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> FoldValues.fromXContent(p, ignoreUnknownFields), FOLD_VALUES);
        return parser;
    }

    public ValidationLoss(String lossType, List<FoldValues> values) {
        this.lossType = Objects.requireNonNull(lossType);
        this.foldValues = Objects.requireNonNull(values);
    }

    public ValidationLoss(StreamInput in) throws IOException {
        this.lossType = in.readString();
        this.foldValues = in.readList(FoldValues::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.lossType);
        out.writeList(this.foldValues);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(LOSS_TYPE.getPreferredName(), this.lossType);
        builder.field(FOLD_VALUES.getPreferredName(), this.foldValues);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationLoss that = (ValidationLoss)o;
        return Objects.equals(this.lossType, that.lossType) && Objects.equals(this.foldValues, that.foldValues);
    }

    public int hashCode() {
        return Objects.hash(this.lossType, this.foldValues);
    }
}

