/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.xpack.core.ml.inference.results.FeatureImportance;
import org.elasticsearch.xpack.core.ml.inference.results.SingleValueInferenceResults;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.RegressionConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class RegressionInferenceResults
extends SingleValueInferenceResults {
    public static final String NAME = "regression";
    private final String resultsField;

    public RegressionInferenceResults(double value, InferenceConfig config) {
        this(value, config, Collections.emptyList());
    }

    public RegressionInferenceResults(double value, InferenceConfig config, List<FeatureImportance> featureImportance) {
        this(value, ((RegressionConfig)config).getResultsField(), ((RegressionConfig)config).getNumTopFeatureImportanceValues(), featureImportance);
    }

    public RegressionInferenceResults(double value, String resultsField) {
        this(value, resultsField, 0, Collections.emptyList());
    }

    public RegressionInferenceResults(double value, String resultsField, List<FeatureImportance> featureImportance) {
        this(value, resultsField, featureImportance.size(), featureImportance);
    }

    public RegressionInferenceResults(double value, String resultsField, int topNFeatures, List<FeatureImportance> featureImportance) {
        super(value, SingleValueInferenceResults.takeTopFeatureImportances(featureImportance, topNFeatures));
        this.resultsField = resultsField;
    }

    public RegressionInferenceResults(StreamInput in) throws IOException {
        super(in);
        this.resultsField = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.resultsField);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RegressionInferenceResults that = (RegressionInferenceResults)object;
        return Objects.equals(this.value(), that.value()) && Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.getFeatureImportance(), that.getFeatureImportance());
    }

    public int hashCode() {
        return Objects.hash(this.value(), this.resultsField, this.getFeatureImportance());
    }

    @Override
    public Object predictedValue() {
        return super.value();
    }

    @Override
    public void writeResult(IngestDocument document, String parentResultField) {
        ExceptionsHelper.requireNonNull(document, "document");
        ExceptionsHelper.requireNonNull(parentResultField, "parentResultField");
        document.setFieldValue(parentResultField, this.asMap());
    }

    @Override
    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.resultsField, this.value());
        if (!this.getFeatureImportance().isEmpty()) {
            map.put("feature_importance", this.getFeatureImportance().stream().map(FeatureImportance::toMap).collect(Collectors.toList()));
        }
        return map;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(this.resultsField, this.value());
        if (this.getFeatureImportance().size() > 0) {
            builder.field("feature_importance", this.getFeatureImportance());
        }
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }
}

