/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.ml.inference.results.FeatureImportance;
import org.elasticsearch.xpack.core.ml.inference.results.InferenceResults;

public abstract class SingleValueInferenceResults
implements InferenceResults {
    public static final String FEATURE_IMPORTANCE = "feature_importance";
    private final double value;
    private final List<FeatureImportance> featureImportance;

    static List<FeatureImportance> takeTopFeatureImportances(List<FeatureImportance> unsortedFeatureImportances, int numTopFeatures) {
        if (unsortedFeatureImportances == null || unsortedFeatureImportances.isEmpty()) {
            return unsortedFeatureImportances;
        }
        return unsortedFeatureImportances.stream().sorted((l, r) -> Double.compare(Math.abs(r.getImportance()), Math.abs(l.getImportance()))).limit(numTopFeatures).collect(Collectors.toList());
    }

    SingleValueInferenceResults(StreamInput in) throws IOException {
        this.value = in.readDouble();
        this.featureImportance = in.getVersion().onOrAfter(Version.V_7_7_0) ? in.readList(FeatureImportance::new) : Collections.emptyList();
    }

    SingleValueInferenceResults(double value, List<FeatureImportance> featureImportance) {
        this.value = value;
        this.featureImportance = featureImportance == null ? Collections.emptyList() : featureImportance;
    }

    public Double value() {
        return this.value;
    }

    public List<FeatureImportance> getFeatureImportance() {
        return this.featureImportance;
    }

    public String valueAsString() {
        return String.valueOf(this.value);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.value);
        if (out.getVersion().onOrAfter(Version.V_7_7_0)) {
            out.writeList(this.featureImportance);
        }
    }
}

