/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.persistence;

import java.util.Collections;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.xpack.core.ml.utils.MlIndexAndAlias;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public final class AnomalyDetectorsIndex {
    public static final int CONFIG_INDEX_MAX_RESULTS_WINDOW = 10000;
    private static final String RESULTS_MAPPINGS_VERSION_VARIABLE = "xpack.ml.version";
    private static final String RESOURCE_PATH = "/org/elasticsearch/xpack/core/ml/anomalydetection/";

    private AnomalyDetectorsIndex() {
    }

    public static String jobResultsIndexPrefix() {
        return ".ml-anomalies-";
    }

    public static String jobResultsAliasedName(String jobId) {
        return ".ml-anomalies-" + jobId;
    }

    public static String resultsWriteAlias(String jobId) {
        return ".ml-anomalies-.write-" + jobId;
    }

    public static String jobStateIndexWriteAlias() {
        return ".ml-state-write";
    }

    public static String jobStateIndexPattern() {
        return ".ml-state*";
    }

    public static void createStateIndexAndAliasIfNecessary(Client client, ClusterState state, IndexNameExpressionResolver resolver, ActionListener<Boolean> finalListener) {
        MlIndexAndAlias.createIndexAndAliasIfNecessary(client, state, resolver, ".ml-state", AnomalyDetectorsIndex.jobStateIndexWriteAlias(), finalListener);
    }

    public static String resultsMapping() {
        return AnomalyDetectorsIndex.resultsMapping("_doc");
    }

    public static String resultsMapping(String mappingType) {
        return TemplateUtils.loadTemplate("/org/elasticsearch/xpack/core/ml/anomalydetection/results_index_mappings.json", Version.CURRENT.toString(), RESULTS_MAPPINGS_VERSION_VARIABLE, Collections.singletonMap("xpack.ml.mapping_type", mappingType));
    }
}

