/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class DelegatePkiAuthenticationResponse
extends ActionResponse
implements ToXContentObject {
    private static final ParseField ACCESS_TOKEN_FIELD = new ParseField("access_token", new String[0]);
    private static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    private static final ParseField EXPIRES_IN_FIELD = new ParseField("expires_in", new String[0]);
    public static final ConstructingObjectParser<DelegatePkiAuthenticationResponse, Void> PARSER = new ConstructingObjectParser("delegate_pki_response", true, a -> {
        String accessToken = (String)a[0];
        String type = (String)a[1];
        if (!"Bearer".equals(type)) {
            throw new IllegalArgumentException("Unknown token type [" + type + "], only [Bearer] type permitted");
        }
        Long expiresIn = (Long)a[2];
        return new DelegatePkiAuthenticationResponse(accessToken, TimeValue.timeValueSeconds((long)expiresIn));
    });
    private String accessToken;
    private TimeValue expiresIn;

    DelegatePkiAuthenticationResponse() {
    }

    public DelegatePkiAuthenticationResponse(String accessToken, TimeValue expiresIn) {
        this.accessToken = Objects.requireNonNull(accessToken);
        this.expiresIn = TimeValue.timeValueSeconds((long)Objects.requireNonNull(expiresIn).getSeconds());
    }

    public DelegatePkiAuthenticationResponse(StreamInput input) throws IOException {
        super(input);
        this.accessToken = input.readString();
        this.expiresIn = input.readTimeValue();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public TimeValue getExpiresIn() {
        return this.expiresIn;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.accessToken);
        out.writeTimeValue(this.expiresIn);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DelegatePkiAuthenticationResponse that = (DelegatePkiAuthenticationResponse)((Object)o);
        return Objects.equals(this.accessToken, that.accessToken) && Objects.equals(this.expiresIn, that.expiresIn);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.expiresIn);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(ACCESS_TOKEN_FIELD.getPreferredName(), this.accessToken).field(TYPE_FIELD.getPreferredName(), "Bearer").field(EXPIRES_IN_FIELD.getPreferredName(), this.expiresIn.getSeconds());
        return builder.endObject();
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ACCESS_TOKEN_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TYPE_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), EXPIRES_IN_FIELD);
    }
}

