/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class InvalidateApiKeyRequest
extends ActionRequest {
    private final String realmName;
    private final String userName;
    private final String id;
    private final String name;
    private final boolean ownedByAuthenticatedUser;

    public InvalidateApiKeyRequest() {
        this(null, null, null, null, false);
    }

    public InvalidateApiKeyRequest(StreamInput in) throws IOException {
        super(in);
        this.realmName = in.readOptionalString();
        this.userName = in.readOptionalString();
        this.id = in.readOptionalString();
        this.name = in.readOptionalString();
        this.ownedByAuthenticatedUser = in.getVersion().onOrAfter(Version.V_7_4_0) ? in.readOptionalBoolean() : false;
    }

    public InvalidateApiKeyRequest(@Nullable String realmName, @Nullable String userName, @Nullable String id, @Nullable String name, boolean ownedByAuthenticatedUser) {
        this.realmName = realmName;
        this.userName = userName;
        this.id = id;
        this.name = name;
        this.ownedByAuthenticatedUser = ownedByAuthenticatedUser;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean ownedByAuthenticatedUser() {
        return this.ownedByAuthenticatedUser;
    }

    public static InvalidateApiKeyRequest usingRealmName(String realmName) {
        return new InvalidateApiKeyRequest(realmName, null, null, null, false);
    }

    public static InvalidateApiKeyRequest usingUserName(String userName) {
        return new InvalidateApiKeyRequest(null, userName, null, null, false);
    }

    public static InvalidateApiKeyRequest usingRealmAndUserName(String realmName, String userName) {
        return new InvalidateApiKeyRequest(realmName, userName, null, null, false);
    }

    public static InvalidateApiKeyRequest usingApiKeyId(String id, boolean ownedByAuthenticatedUser) {
        return new InvalidateApiKeyRequest(null, null, id, null, ownedByAuthenticatedUser);
    }

    public static InvalidateApiKeyRequest usingApiKeyName(String name, boolean ownedByAuthenticatedUser) {
        return new InvalidateApiKeyRequest(null, null, null, name, ownedByAuthenticatedUser);
    }

    public static InvalidateApiKeyRequest forOwnedApiKeys() {
        return new InvalidateApiKeyRequest(null, null, null, null, true);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!(Strings.hasText((String)this.realmName) || Strings.hasText((String)this.userName) || Strings.hasText((String)this.id) || Strings.hasText((String)this.name) || this.ownedByAuthenticatedUser)) {
            validationException = ValidateActions.addValidationError((String)"One of [api key id, api key name, username, realm name] must be specified if [owner] flag is false", (ActionRequestValidationException)validationException);
        }
        if ((Strings.hasText((String)this.id) || Strings.hasText((String)this.name)) && (Strings.hasText((String)this.realmName) || Strings.hasText((String)this.userName))) {
            validationException = ValidateActions.addValidationError((String)"username or realm name must not be specified when the api key id or api key name is specified", validationException);
        }
        if (this.ownedByAuthenticatedUser && (Strings.hasText((String)this.realmName) || Strings.hasText((String)this.userName))) {
            validationException = ValidateActions.addValidationError((String)"neither username nor realm-name may be specified when invalidating owned API keys", (ActionRequestValidationException)validationException);
        }
        if (Strings.hasText((String)this.id) && Strings.hasText((String)this.name)) {
            validationException = ValidateActions.addValidationError((String)"only one of [api key id, api key name] can be specified", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.realmName);
        out.writeOptionalString(this.userName);
        out.writeOptionalString(this.id);
        out.writeOptionalString(this.name);
        if (out.getVersion().onOrAfter(Version.V_7_4_0)) {
            out.writeOptionalBoolean(Boolean.valueOf(this.ownedByAuthenticatedUser));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        InvalidateApiKeyRequest that = (InvalidateApiKeyRequest)((Object)o);
        return this.ownedByAuthenticatedUser == that.ownedByAuthenticatedUser && Objects.equals(this.realmName, that.realmName) && Objects.equals(this.userName, that.userName) && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.realmName, this.userName, this.id, this.name, this.ownedByAuthenticatedUser);
    }
}

