/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.core.transform.transforms.NodeAttributes;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerPosition;
import org.elasticsearch.xpack.core.transform.transforms.TransformProgress;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;

public class TransformState
implements Task.Status,
PersistentTaskState {
    public static final String NAME = "data_frame/transforms";
    private final TransformTaskState taskState;
    private final IndexerState indexerState;
    private final TransformProgress progress;
    private final long checkpoint;
    @Nullable
    private final TransformIndexerPosition position;
    @Nullable
    private final String reason;
    @Nullable
    private NodeAttributes node;
    private final boolean shouldStopAtNextCheckpoint;
    public static final ParseField TASK_STATE = new ParseField("task_state", new String[0]);
    public static final ParseField INDEXER_STATE = new ParseField("indexer_state", new String[0]);
    public static final ParseField CURRENT_POSITION = new ParseField("current_position", new String[0]);
    public static final ParseField POSITION = new ParseField("position", new String[0]);
    public static final ParseField CHECKPOINT = new ParseField("checkpoint", new String[0]);
    public static final ParseField REASON = new ParseField("reason", new String[0]);
    public static final ParseField PROGRESS = new ParseField("progress", new String[0]);
    public static final ParseField NODE = new ParseField("node", new String[0]);
    public static final ParseField SHOULD_STOP_AT_NEXT_CHECKPOINT = new ParseField("should_stop_at_checkpoint", new String[0]);
    public static final ConstructingObjectParser<TransformState, Void> PARSER = new ConstructingObjectParser("data_frame/transforms", true, args -> {
        TransformTaskState taskState = (TransformTaskState)((Object)((Object)args[0]));
        IndexerState indexerState = (IndexerState)((Object)((Object)args[1]));
        Map bwcCurrentPosition = (Map)args[2];
        TransformIndexerPosition transformIndexerPosition = (TransformIndexerPosition)args[3];
        if (bwcCurrentPosition != null && transformIndexerPosition == null) {
            transformIndexerPosition = new TransformIndexerPosition(bwcCurrentPosition, null);
        }
        long checkpoint = (Long)args[4];
        String reason = (String)args[5];
        TransformProgress progress = (TransformProgress)args[6];
        NodeAttributes node = (NodeAttributes)args[7];
        boolean shouldStopAtNextCheckpoint = args[8] == null ? false : (Boolean)args[8];
        return new TransformState(taskState, indexerState, transformIndexerPosition, checkpoint, reason, progress, node, shouldStopAtNextCheckpoint);
    });

    public TransformState(TransformTaskState taskState, IndexerState indexerState, @Nullable TransformIndexerPosition position, long checkpoint, @Nullable String reason, @Nullable TransformProgress progress, @Nullable NodeAttributes node, boolean shouldStopAtNextCheckpoint) {
        this.taskState = taskState;
        this.indexerState = indexerState;
        this.position = position;
        this.checkpoint = checkpoint;
        this.reason = reason;
        this.progress = progress;
        this.node = node;
        this.shouldStopAtNextCheckpoint = shouldStopAtNextCheckpoint;
    }

    public TransformState(TransformTaskState taskState, IndexerState indexerState, @Nullable TransformIndexerPosition position, long checkpoint, @Nullable String reason, @Nullable TransformProgress progress, @Nullable NodeAttributes node) {
        this(taskState, indexerState, position, checkpoint, reason, progress, node, false);
    }

    public TransformState(TransformTaskState taskState, IndexerState indexerState, @Nullable TransformIndexerPosition position, long checkpoint, @Nullable String reason, @Nullable TransformProgress progress) {
        this(taskState, indexerState, position, checkpoint, reason, progress, null);
    }

    public TransformState(StreamInput in) throws IOException {
        this.taskState = TransformTaskState.fromStream(in);
        this.indexerState = IndexerState.fromStream(in);
        if (in.getVersion().onOrAfter(Version.V_7_3_0)) {
            this.position = (TransformIndexerPosition)in.readOptionalWriteable(TransformIndexerPosition::new);
        } else {
            Map pos = in.readMap();
            this.position = new TransformIndexerPosition(pos, null);
        }
        this.checkpoint = in.readLong();
        this.reason = in.readOptionalString();
        this.progress = (TransformProgress)in.readOptionalWriteable(TransformProgress::new);
        this.node = in.getVersion().onOrAfter(Version.V_7_3_0) ? (NodeAttributes)in.readOptionalWriteable(NodeAttributes::new) : null;
        this.shouldStopAtNextCheckpoint = in.getVersion().onOrAfter(Version.V_7_6_0) ? in.readBoolean() : false;
    }

    public TransformTaskState getTaskState() {
        return this.taskState;
    }

    public IndexerState getIndexerState() {
        return this.indexerState;
    }

    public TransformIndexerPosition getPosition() {
        return this.position;
    }

    public long getCheckpoint() {
        return this.checkpoint;
    }

    public TransformProgress getProgress() {
        return this.progress;
    }

    public String getReason() {
        return this.reason;
    }

    public NodeAttributes getNode() {
        return this.node;
    }

    public TransformState setNode(NodeAttributes node) {
        this.node = node;
        return this;
    }

    public boolean shouldStopAtNextCheckpoint() {
        return this.shouldStopAtNextCheckpoint;
    }

    public static TransformState fromXContent(XContentParser parser) {
        try {
            return (TransformState)PARSER.parse(parser, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TASK_STATE.getPreferredName(), this.taskState.value());
        builder.field(INDEXER_STATE.getPreferredName(), this.indexerState.value());
        if (this.position != null) {
            builder.field(POSITION.getPreferredName(), (ToXContent)this.position);
        }
        builder.field(CHECKPOINT.getPreferredName(), this.checkpoint);
        if (this.reason != null) {
            builder.field(REASON.getPreferredName(), this.reason);
        }
        if (this.progress != null) {
            builder.field(PROGRESS.getPreferredName(), (ToXContent)this.progress);
        }
        if (this.node != null) {
            builder.field(NODE.getPreferredName(), (ToXContent)this.node);
        }
        builder.field(SHOULD_STOP_AT_NEXT_CHECKPOINT.getPreferredName(), this.shouldStopAtNextCheckpoint);
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.taskState.writeTo(out);
        this.indexerState.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
            out.writeOptionalWriteable((Writeable)this.position);
        } else {
            out.writeMap(this.position != null ? this.position.getIndexerPosition() : null);
        }
        out.writeLong(this.checkpoint);
        out.writeOptionalString(this.reason);
        out.writeOptionalWriteable((Writeable)this.progress);
        if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
            out.writeOptionalWriteable((Writeable)this.node);
        }
        if (out.getVersion().onOrAfter(Version.V_7_6_0)) {
            out.writeBoolean(this.shouldStopAtNextCheckpoint);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformState that = (TransformState)other;
        return Objects.equals((Object)this.taskState, (Object)that.taskState) && Objects.equals((Object)this.indexerState, (Object)that.indexerState) && Objects.equals(this.position, that.position) && this.checkpoint == that.checkpoint && Objects.equals(this.reason, that.reason) && Objects.equals(this.progress, that.progress) && Objects.equals(this.shouldStopAtNextCheckpoint, that.shouldStopAtNextCheckpoint) && Objects.equals(this.node, that.node);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.taskState, this.indexerState, this.position, this.checkpoint, this.reason, this.progress, this.node, this.shouldStopAtNextCheckpoint});
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> TransformTaskState.fromString(p.text()), TASK_STATE, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> IndexerState.fromString(p.text()), INDEXER_STATE, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), XContentParser::mapOrdered, CURRENT_POSITION, ObjectParser.ValueType.OBJECT);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), TransformIndexerPosition::fromXContent, POSITION, ObjectParser.ValueType.OBJECT);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), CHECKPOINT);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), REASON);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (arg_0, arg_1) -> TransformProgress.PARSER.apply(arg_0, arg_1), PROGRESS, ObjectParser.ValueType.OBJECT);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (arg_0, arg_1) -> NodeAttributes.PARSER.apply(arg_0, arg_1), NODE, ObjectParser.ValueType.OBJECT);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), SHOULD_STOP_AT_NEXT_CHECKPOINT);
    }
}

