/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms.pivot;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.xpack.core.transform.transforms.pivot.ScriptConfig;
import org.elasticsearch.xpack.core.transform.transforms.pivot.SingleGroupSource;

public class DateHistogramGroupSource
extends SingleGroupSource {
    private static final int CALENDAR_INTERVAL_ID = 1;
    private static final int FIXED_INTERVAL_ID = 0;
    private static final String NAME = "data_frame_date_histogram_group";
    private static final ParseField TIME_ZONE = new ParseField("time_zone", new String[0]);
    private static final ConstructingObjectParser<DateHistogramGroupSource, Void> STRICT_PARSER = DateHistogramGroupSource.createParser(false);
    private static final ConstructingObjectParser<DateHistogramGroupSource, Void> LENIENT_PARSER = DateHistogramGroupSource.createParser(true);
    private final Interval interval;
    private final ZoneId timeZone;
    private final Rounding.Prepared rounding;

    private Interval readInterval(StreamInput in) throws IOException {
        byte id = in.readByte();
        switch (id) {
            case 0: {
                return new FixedInterval(in);
            }
            case 1: {
                return new CalendarInterval(in);
            }
        }
        throw new IllegalArgumentException("unknown interval type [" + id + "]");
    }

    private void writeInterval(Interval interval, StreamOutput out) throws IOException {
        out.write((int)interval.getIntervalTypeId());
        interval.writeTo(out);
    }

    public DateHistogramGroupSource(String field, ScriptConfig scriptConfig, Interval interval, ZoneId timeZone) {
        super(field, scriptConfig);
        this.interval = interval;
        this.timeZone = timeZone;
        this.rounding = this.buildRounding();
    }

    public DateHistogramGroupSource(StreamInput in) throws IOException {
        super(in);
        this.interval = this.readInterval(in);
        this.timeZone = in.readOptionalZoneId();
        if (in.getVersion().before(Version.V_7_3_0)) {
            in.readOptionalString();
        }
        this.rounding = this.buildRounding();
    }

    private Rounding.Prepared buildRounding() {
        Rounding.DateTimeUnit timeUnit = (Rounding.DateTimeUnit)DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(this.interval.toString());
        Rounding.Builder roundingBuilder = timeUnit != null ? new Rounding.Builder(timeUnit) : new Rounding.Builder(TimeValue.parseTimeValue((String)this.interval.toString(), (String)this.interval.getName()));
        if (this.timeZone != null) {
            roundingBuilder.timeZone(this.timeZone);
        }
        return roundingBuilder.build().prepareForUnknown();
    }

    private static ConstructingObjectParser<DateHistogramGroupSource, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, lenient, args -> {
            String field = (String)args[0];
            ScriptConfig scriptConfig = (ScriptConfig)((Object)((Object)args[1]));
            String fixedInterval = (String)args[2];
            String calendarInterval = (String)args[3];
            ZoneId zoneId = (ZoneId)args[4];
            Interval interval = null;
            if (fixedInterval != null && calendarInterval != null) {
                throw new IllegalArgumentException("You must specify either fixed_interval or calendar_interval, found both");
            }
            if (fixedInterval != null) {
                interval = new FixedInterval(new DateHistogramInterval(fixedInterval));
            } else if (calendarInterval != null) {
                interval = new CalendarInterval(new DateHistogramInterval(calendarInterval));
            } else {
                throw new IllegalArgumentException("You must specify either fixed_interval or calendar_interval, found none");
            }
            return new DateHistogramGroupSource(field, scriptConfig, interval, zoneId);
        });
        DateHistogramGroupSource.declareValuesSourceFields(parser, lenient);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("fixed_interval", new String[0]));
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("calendar_interval", new String[0]));
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return ZoneId.of(p.text());
            }
            return ZoneOffset.ofHours(p.intValue());
        }, TIME_ZONE, ObjectParser.ValueType.LONG);
        return parser;
    }

    public static DateHistogramGroupSource fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? (DateHistogramGroupSource)LENIENT_PARSER.apply(parser, null) : (DateHistogramGroupSource)STRICT_PARSER.apply(parser, null);
    }

    @Override
    public SingleGroupSource.Type getType() {
        return SingleGroupSource.Type.DATE_HISTOGRAM;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public Rounding.Prepared getRounding() {
        return this.rounding;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.writeInterval(this.interval, out);
        out.writeOptionalZoneId(this.timeZone);
        if (out.getVersion().before(Version.V_7_3_0)) {
            out.writeOptionalString(null);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        super.innerXContent(builder, params);
        this.interval.toXContent(builder, params);
        if (this.timeZone != null) {
            builder.field(TIME_ZONE.getPreferredName(), this.timeZone.toString());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DateHistogramGroupSource that = (DateHistogramGroupSource)other;
        return Objects.equals(this.field, that.field) && Objects.equals(this.interval, that.interval) && Objects.equals(this.timeZone, that.timeZone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.interval, this.timeZone);
    }

    @Override
    public boolean supportsIncrementalBucketUpdate() {
        return false;
    }

    public static class CalendarInterval
    implements Interval {
        private static final String NAME = "calendar_interval";
        private final DateHistogramInterval interval;

        public CalendarInterval(DateHistogramInterval interval) {
            this.interval = interval;
            if (DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(interval.toString()) == null) {
                throw new IllegalArgumentException("The supplied interval [" + interval + "] could not be parsed as a calendar interval.");
            }
        }

        public CalendarInterval(StreamInput in) throws IOException {
            this.interval = new DateHistogramInterval(in);
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public DateHistogramInterval getInterval() {
            return this.interval;
        }

        @Override
        public byte getIntervalTypeId() {
            return 1;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(NAME);
            this.interval.toXContent(builder, params);
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.interval.writeTo(out);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CalendarInterval that = (CalendarInterval)other;
            return Objects.equals(this.interval, that.interval);
        }

        public int hashCode() {
            return Objects.hash(this.interval);
        }

        public String toString() {
            return this.interval.toString();
        }
    }

    public static class FixedInterval
    implements Interval {
        private static final String NAME = "fixed_interval";
        private final DateHistogramInterval interval;

        public FixedInterval(DateHistogramInterval interval) {
            this.interval = interval;
        }

        public FixedInterval(StreamInput in) throws IOException {
            this.interval = new DateHistogramInterval(in);
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public DateHistogramInterval getInterval() {
            return this.interval;
        }

        @Override
        public byte getIntervalTypeId() {
            return 0;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(NAME);
            this.interval.toXContent(builder, params);
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.interval.writeTo(out);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            FixedInterval that = (FixedInterval)other;
            return Objects.equals(this.interval, that.interval);
        }

        public int hashCode() {
            return Objects.hash(this.interval);
        }

        public String toString() {
            return this.interval.toString();
        }
    }

    public static interface Interval
    extends Writeable,
    ToXContentFragment {
        public String getName();

        public DateHistogramInterval getInterval();

        public byte getIntervalTypeId();
    }
}

