/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms.pivot;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.AbstractObjectParser;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.transform.transforms.pivot.ScriptConfig;

public abstract class SingleGroupSource
implements Writeable,
ToXContentObject {
    protected static final ParseField FIELD = new ParseField("field", new String[0]);
    protected static final ParseField SCRIPT = new ParseField("script", new String[0]);
    protected final String field;
    protected final ScriptConfig scriptConfig;

    static <T> void declareValuesSourceFields(AbstractObjectParser<? extends SingleGroupSource, T> parser, boolean lenient) {
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), FIELD);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ScriptConfig.fromXContent(p, lenient), SCRIPT);
    }

    public SingleGroupSource(String field, ScriptConfig scriptConfig) {
        this.field = field;
        this.scriptConfig = scriptConfig;
    }

    public SingleGroupSource(StreamInput in) throws IOException {
        this.field = in.readOptionalString();
        this.scriptConfig = in.getVersion().onOrAfter(Version.V_7_7_0) ? (ScriptConfig)in.readOptionalWriteable(ScriptConfig::new) : null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerXContent(builder, params);
        builder.endObject();
        return builder;
    }

    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.field != null) {
            builder.field(FIELD.getPreferredName(), this.field);
        }
        if (this.scriptConfig != null) {
            builder.field(SCRIPT.getPreferredName(), (ToXContent)this.scriptConfig);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.field);
        if (out.getVersion().onOrAfter(Version.V_7_7_0)) {
            out.writeOptionalWriteable((Writeable)this.scriptConfig);
        }
    }

    public abstract Type getType();

    public abstract boolean supportsIncrementalBucketUpdate();

    public String getField() {
        return this.field;
    }

    public ScriptConfig getScriptConfig() {
        return this.scriptConfig;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SingleGroupSource that = (SingleGroupSource)other;
        return Objects.equals(this.field, that.field) && Objects.equals((Object)this.scriptConfig, (Object)that.scriptConfig);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.scriptConfig});
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    @Nullable
    public String getMappingType() {
        return null;
    }

    public Object transformBucketKey(Object key) {
        return key;
    }

    public static enum Type {
        TERMS(0),
        HISTOGRAM(1),
        DATE_HISTOGRAM(2),
        GEOTILE_GRID(3);

        private final byte id;

        private Type(int id) {
            this.id = (byte)id;
        }

        public byte getId() {
            return this.id;
        }

        public static Type fromId(byte id) {
            switch (id) {
                case 0: {
                    return TERMS;
                }
                case 1: {
                    return HISTOGRAM;
                }
                case 2: {
                    return DATE_HISTOGRAM;
                }
                case 3: {
                    return GEOTILE_GRID;
                }
            }
            throw new IllegalArgumentException("unknown type");
        }

        public String value() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

