/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.process.internal.ExecutorsFactory;
import org.glassfish.jersey.spi.RequestExecutorsProvider;
import org.glassfish.jersey.spi.ResponseExecutorsProvider;

class ClientAsyncExecutorsFactory
extends ExecutorsFactory<ClientRequest> {
    private final ExecutorService requestingExecutor = this.getInitialRequestingExecutor(new RequestExecutorsProvider(){

        public ExecutorService getRequestingExecutor() {
            return Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("jersey-client-async-executor-%d").build());
        }
    });
    private final ExecutorService respondingExecutor = this.getInitialRespondingExecutor(new ResponseExecutorsProvider(){

        public ExecutorService getRespondingExecutor() {
            return MoreExecutors.sameThreadExecutor();
        }
    });

    public ClientAsyncExecutorsFactory(ServiceLocator locator) {
        super(locator);
    }

    public ExecutorService getRequestingExecutor(ClientRequest request) {
        return this.requestingExecutor;
    }

    public ExecutorService getRespondingExecutor(ClientRequest request) {
        return this.respondingExecutor;
    }
}

