/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.graalvm.buildtools.Utils;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="native-build-tools")
public class NativeExtension
extends AbstractMavenLifecycleParticipant
implements LogEnabled {
    private static final String JUNIT_PLATFORM_LISTENERS_UID_TRACKING_ENABLED = "junit.platform.listeners.uid.tracking.enabled";
    private static final String JUNIT_PLATFORM_LISTENERS_UID_TRACKING_OUTPUT_DIR = "junit.platform.listeners.uid.tracking.output.dir";
    private static final String NATIVEIMAGE_IMAGECODE = "org.graalvm.nativeimage.imagecode";
    private static Logger logger;

    public void enableLogging(Logger logger) {
        NativeExtension.logger = logger;
    }

    static String testIdsDirectory(String baseDir) {
        return baseDir + File.separator + "test-ids";
    }

    static String buildAgentArgument(String baseDir, Context context, List<String> agentOptions) {
        ArrayList<String> options = new ArrayList<String>(agentOptions);
        String effectiveOutputDir = NativeExtension.agentOutputDirectoryFor(baseDir, context);
        if (context == Context.test) {
            effectiveOutputDir = effectiveOutputDir + File.separator + "session-{pid}-{datetime}";
        }
        options.add("config-output-dir=" + effectiveOutputDir);
        return "-agentlib:native-image-agent=" + String.join((CharSequence)",", options);
    }

    static String agentOutputDirectoryFor(String baseDir, Context context) {
        return (baseDir + "/native/agent-output/" + (Object)((Object)context)).replace('/', File.separatorChar);
    }

    public void afterProjectsRead(MavenSession session) {
        for (MavenProject project : session.getProjects()) {
            Build build = project.getBuild();
            NativeExtension.withPlugin(build, "native-maven-plugin", nativePlugin -> {
                String target = build.getDirectory();
                String testIdsDir = NativeExtension.testIdsDirectory(target);
                boolean isAgentEnabled = NativeExtension.isAgentEnabled(session, nativePlugin);
                String selectedOptionsName = NativeExtension.getSelectedOptionsName(session);
                NativeExtension.withPlugin(build, "maven-surefire-plugin", surefirePlugin -> {
                    NativeExtension.configureJunitListener(surefirePlugin, testIdsDir);
                    if (isAgentEnabled) {
                        List<String> agentOptions = NativeExtension.getAgentOptions(nativePlugin, Context.test, selectedOptionsName);
                        NativeExtension.configureAgentForSurefire(surefirePlugin, NativeExtension.buildAgentArgument(target, Context.test, agentOptions));
                    }
                });
                if (isAgentEnabled) {
                    NativeExtension.withPlugin(build, "exec-maven-plugin", execPlugin -> NativeExtension.updatePluginConfiguration(execPlugin, (exec, config) -> {
                        if ("java-agent".equals(exec.getId())) {
                            Xpp3Dom commandlineArgs = NativeExtension.findOrAppend(config, "arguments");
                            Xpp3Dom[] arrayOfChildren = commandlineArgs.getChildren();
                            for (int i = 0; i < arrayOfChildren.length; ++i) {
                                commandlineArgs.removeChild(0);
                            }
                            ArrayList<Xpp3Dom> children = new ArrayList<Xpp3Dom>();
                            Collections.addAll(children, arrayOfChildren);
                            Xpp3Dom arg = new Xpp3Dom("argument");
                            List<String> agentOptions = NativeExtension.getAgentOptions(nativePlugin, Context.main, selectedOptionsName);
                            arg.setValue(NativeExtension.buildAgentArgument(target, Context.main, agentOptions));
                            children.add(0, arg);
                            arg = new Xpp3Dom("argument");
                            arg.setValue("-Dorg.graalvm.nativeimage.imagecode=agent");
                            children.add(1, arg);
                            for (Xpp3Dom child : children) {
                                commandlineArgs.addChild(child);
                            }
                            NativeExtension.findOrAppend(config, "executable").setValue(NativeExtension.getGraalvmJava());
                        }
                    }));
                    NativeExtension.updatePluginConfiguration(nativePlugin, (exec, configuration) -> {
                        Context context = exec.getGoals().stream().anyMatch("test"::equals) ? Context.test : Context.main;
                        Xpp3Dom agentResourceDirectory = NativeExtension.findOrAppend(configuration, "agentResourceDirectory");
                        agentResourceDirectory.setValue(NativeExtension.agentOutputDirectoryFor(target, context));
                        if (context == Context.test) {
                            NativeExtension.setupMergeAgentFiles(exec, configuration, context);
                        }
                    });
                }
            });
        }
    }

    private static void setupMergeAgentFiles(PluginExecution exec, Xpp3Dom configuration, Context context) {
        ArrayList<String> goals = new ArrayList<String>();
        goals.add("merge-agent-files");
        goals.addAll(exec.getGoals());
        exec.setGoals(goals);
        Xpp3Dom agentContext = NativeExtension.findOrAppend(configuration, "context");
        agentContext.setValue(context.name());
    }

    private static void withPlugin(Build build, String artifactId, Consumer<? super Plugin> consumer) {
        build.getPlugins().stream().filter(p -> artifactId.equals(p.getArtifactId())).findFirst().ifPresent(consumer);
    }

    private static boolean isAgentEnabled(MavenSession session, Plugin nativePlugin) {
        Xpp3Dom enabled;
        String systemProperty = session.getSystemProperties().getProperty("agent");
        if (systemProperty != null) {
            return NativeExtension.parseBoolean("agent system property", systemProperty);
        }
        Xpp3Dom agent = NativeExtension.getAgentNode(nativePlugin);
        if (agent != null && (enabled = agent.getChild("enabled")) != null) {
            return NativeExtension.parseBoolean("<enabled>", enabled.getValue());
        }
        return false;
    }

    private static String getSelectedOptionsName(MavenSession session) {
        String selectedOptionsName = session.getSystemProperties().getProperty("agentOptions");
        if (selectedOptionsName == null) {
            return null;
        }
        return NativeExtension.assertNotEmptyAndTrim(selectedOptionsName, "agentOptions system property must have a value");
    }

    private static List<String> getAgentOptions(Plugin nativePlugin, Context context, String selectedOptionsName) {
        ArrayList<String> optionsList = new ArrayList<String>();
        Xpp3Dom agent = NativeExtension.getAgentNode(nativePlugin);
        if (agent != null) {
            for (Xpp3Dom options : agent.getChildren("options")) {
                String name = options.getAttribute("name");
                if (name != null) {
                    name = NativeExtension.assertNotEmptyAndTrim(name, "<options> must declare a non-empty name attribute or omit the name attribute");
                }
                if (name != null && !name.equals(context.name()) && !name.equals(selectedOptionsName)) continue;
                NativeExtension.processOptionNodes(options, optionsList);
            }
        }
        return optionsList;
    }

    private static void processOptionNodes(Xpp3Dom options, List<String> optionsList) {
        for (Xpp3Dom option : options.getChildren("option")) {
            String value = NativeExtension.assertNotEmptyAndTrim(option.getValue(), "<option> must declare a value");
            if (value.contains("config-output-dir")) {
                throw new IllegalStateException("config-output-dir cannot be supplied as an agent option");
            }
            optionsList.add(value);
        }
    }

    private static boolean parseBoolean(String description, String value) {
        switch (value = NativeExtension.assertNotEmptyAndTrim(value, description + " must have a value").toLowerCase()) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        throw new IllegalStateException(description + " must have a value of 'true' or 'false'");
    }

    private static String assertNotEmptyAndTrim(String input, String message) {
        if (input == null || input.isEmpty()) {
            throw new IllegalStateException(message);
        }
        return input.trim();
    }

    private static Xpp3Dom getAgentNode(Plugin nativePlugin) {
        Xpp3Dom configuration = (Xpp3Dom)nativePlugin.getConfiguration();
        if (configuration != null) {
            return configuration.getChild("agent");
        }
        return null;
    }

    private static void configureAgentForSurefire(Plugin surefirePlugin, String agentArgument) {
        NativeExtension.updatePluginConfiguration(surefirePlugin, (exec, configuration) -> {
            Xpp3Dom systemProperties = NativeExtension.findOrAppend(configuration, "systemProperties");
            Xpp3Dom agent = NativeExtension.findOrAppend(systemProperties, NATIVEIMAGE_IMAGECODE);
            agent.setValue("agent");
            Xpp3Dom argLine = new Xpp3Dom("argLine");
            argLine.setValue(agentArgument);
            configuration.addChild(argLine);
            NativeExtension.findOrAppend(configuration, "jvm").setValue(NativeExtension.getGraalvmJava());
        });
    }

    private static void configureJunitListener(Plugin surefirePlugin, String testIdsDir) {
        NativeExtension.updatePluginConfiguration(surefirePlugin, (exec, configuration) -> {
            Xpp3Dom systemProperties = NativeExtension.findOrAppend(configuration, "systemProperties");
            Xpp3Dom junitTracking = NativeExtension.findOrAppend(systemProperties, JUNIT_PLATFORM_LISTENERS_UID_TRACKING_ENABLED);
            Xpp3Dom testIdsProperty = NativeExtension.findOrAppend(systemProperties, JUNIT_PLATFORM_LISTENERS_UID_TRACKING_OUTPUT_DIR);
            junitTracking.setValue("true");
            testIdsProperty.setValue(testIdsDir);
        });
    }

    private static void updatePluginConfiguration(Plugin plugin, BiConsumer<PluginExecution, ? super Xpp3Dom> consumer) {
        plugin.getExecutions().forEach(exec -> {
            Xpp3Dom configuration = NativeExtension.configurationBlockOf(exec);
            consumer.accept((PluginExecution)exec, (Xpp3Dom)configuration);
        });
    }

    private static Xpp3Dom configurationBlockOf(PluginExecution exec) {
        Xpp3Dom configuration = (Xpp3Dom)exec.getConfiguration();
        if (configuration == null) {
            configuration = new Xpp3Dom("configuration");
            exec.setConfiguration((Object)configuration);
        }
        return configuration;
    }

    private static Xpp3Dom findOrAppend(Xpp3Dom parent, String childName) {
        Xpp3Dom child = parent.getChild(childName);
        if (child == null) {
            child = new Xpp3Dom(childName);
            parent.addChild(child);
        }
        return child;
    }

    private static String getGraalvmJava() {
        try {
            return Utils.getNativeImage(logger).getParent().resolve("java").toString();
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    static enum Context {
        main,
        test;

    }
}

