/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.nfi.impl.LibFFIType;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.NativeArgumentLibrary;
import com.oracle.truffle.nfi.impl.NativePointer;
import com.oracle.truffle.nfi.impl.NativeString;
import java.nio.ByteBuffer;

abstract class ClosureArgumentNode
extends Node {
    ClosureArgumentNode() {
    }

    public abstract Object execute(Object var1);

    static class StringClosureArgumentNode
    extends ClosureArgumentNode {
        StringClosureArgumentNode() {
        }

        @Override
        public Object execute(Object arg) {
            if (arg == null) {
                return new NativeString(0L);
            }
            return arg;
        }
    }

    static class ObjectClosureArgumentNode
    extends ClosureArgumentNode {
        @CompilerDirectives.CompilationFinal
        TruffleLanguage.LanguageReference<NFILanguageImpl> langRef;

        ObjectClosureArgumentNode() {
        }

        @Override
        public Object execute(Object arg) {
            if (arg == null) {
                if (this.langRef == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.langRef = this.lookupLanguageReference(NFILanguageImpl.class);
                }
                return NativePointer.create((NFILanguageImpl)this.langRef.get(), 0L);
            }
            return arg;
        }
    }

    static class BufferClosureArgumentNode
    extends ClosureArgumentNode {
        private final LibFFIType type;
        @Node.Child
        NativeArgumentLibrary nativeArguments;

        BufferClosureArgumentNode(LibFFIType type) {
            this.type = type;
            this.nativeArguments = (NativeArgumentLibrary)NativeArgumentLibrary.getFactory().create((Object)type);
        }

        @Override
        public Object execute(Object arg) {
            NativeArgumentBuffer.Direct buffer = new NativeArgumentBuffer.Direct((ByteBuffer)arg, 0);
            return this.nativeArguments.deserialize(this.type, buffer);
        }
    }
}

