/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

abstract class NativeArgumentBuffer {
    final int[] patches;
    final Object[] objects;
    private int objIdx;

    int getPatchCount() {
        return this.objIdx;
    }

    protected NativeArgumentBuffer(int objCount) {
        if (objCount > 0) {
            this.patches = new int[objCount];
            this.objects = new Object[objCount];
        } else {
            this.patches = null;
            this.objects = null;
        }
        this.objIdx = 0;
    }

    public void align(int alignment) {
        assert (alignment >= 1);
        int pos = this.getPrimBuffer().position();
        if (pos % alignment != 0) {
            pos += alignment - pos % alignment;
            this.getPrimBuffer().position(pos);
        }
    }

    protected abstract ByteBuffer getPrimBuffer();

    public byte getInt8() {
        return this.getPrimBuffer().get();
    }

    public void putInt8(byte b) {
        this.getPrimBuffer().put(b);
    }

    public short getInt16() {
        return this.getPrimBuffer().getShort();
    }

    public void putInt16(short s) {
        this.getPrimBuffer().putShort(s);
    }

    public int getInt32() {
        return this.getPrimBuffer().getInt();
    }

    public void putInt32(int i) {
        this.getPrimBuffer().putInt(i);
    }

    public long getInt64() {
        return this.getPrimBuffer().getLong();
    }

    public void putInt64(long l) {
        this.getPrimBuffer().putLong(l);
    }

    public float getFloat() {
        return this.getPrimBuffer().getFloat();
    }

    public void putFloat(float f) {
        this.getPrimBuffer().putFloat(f);
    }

    public double getDouble() {
        return this.getPrimBuffer().getDouble();
    }

    public void putDouble(double d) {
        this.getPrimBuffer().putDouble(d);
    }

    public long getPointer(int size) {
        switch (size) {
            case 4: {
                return this.getInt32();
            }
            case 8: {
                return this.getInt64();
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw new AssertionError((Object)("unexpected pointer size " + size));
    }

    public void putPointer(long ptr, int size) {
        switch (size) {
            case 4: {
                this.putInt32((int)ptr);
                break;
            }
            case 8: {
                this.putInt64(ptr);
                break;
            }
            default: {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)("unexpected pointer size " + size));
            }
        }
    }

    public Object getObject(int size) {
        int pos = this.getPrimBuffer().position();
        this.getPrimBuffer().position(pos + size);
        CompilerDirectives.transferToInterpreter();
        throw new AssertionError((Object)"passing TruffleObject from native back to Truffle not yet supported");
    }

    public void putObject(TypeTag tag, Object o, int size) {
        int pos = this.getPrimBuffer().position();
        int idx = this.objIdx++;
        this.patches[idx] = tag.encode(pos);
        this.objects[idx] = o;
        this.getPrimBuffer().position(pos + size);
    }

    static final class Direct
    extends NativeArgumentBuffer {
        private static final Class<? extends ByteBuffer> directByteBuffer = ByteBuffer.allocateDirect(0).getClass();
        private final ByteBuffer primBuffer;

        Direct(ByteBuffer primBuffer, int objCount) {
            super(objCount);
            this.primBuffer = ((ByteBuffer)CompilerDirectives.castExact((Object)primBuffer, directByteBuffer)).slice().order(ByteOrder.nativeOrder());
        }

        @Override
        protected ByteBuffer getPrimBuffer() {
            return (ByteBuffer)CompilerDirectives.castExact((Object)this.primBuffer, directByteBuffer);
        }
    }

    static final class Array
    extends NativeArgumentBuffer {
        private static final Class<? extends ByteBuffer> heapByteBuffer = ByteBuffer.wrap(new byte[0]).getClass();
        final byte[] prim;
        private final ByteBuffer primBuffer;

        Array(int primSize, int objCount) {
            super(objCount);
            this.prim = new byte[primSize];
            this.primBuffer = ByteBuffer.wrap(this.prim).order(ByteOrder.nativeOrder());
        }

        @Override
        protected ByteBuffer getPrimBuffer() {
            return (ByteBuffer)CompilerDirectives.castExact((Object)this.primBuffer, heapByteBuffer);
        }
    }

    static final class TypeTag
    extends Enum<TypeTag> {
        public static final /* enum */ TypeTag OBJECT = new TypeTag();
        public static final /* enum */ TypeTag STRING = new TypeTag();
        public static final /* enum */ TypeTag CLOSURE = new TypeTag();
        public static final /* enum */ TypeTag ENV = new TypeTag();
        public static final /* enum */ TypeTag BOOLEAN_ARRAY = new TypeTag();
        public static final /* enum */ TypeTag BYTE_ARRAY = new TypeTag();
        public static final /* enum */ TypeTag CHAR_ARRAY = new TypeTag();
        public static final /* enum */ TypeTag SHORT_ARRAY = new TypeTag();
        public static final /* enum */ TypeTag INT_ARRAY = new TypeTag();
        public static final /* enum */ TypeTag LONG_ARRAY = new TypeTag();
        public static final /* enum */ TypeTag FLOAT_ARRAY = new TypeTag();
        public static final /* enum */ TypeTag DOUBLE_ARRAY = new TypeTag();
        private static final TypeTag[] VALUES;
        private static final /* synthetic */ TypeTag[] $VALUES;

        public static TypeTag[] values() {
            return (TypeTag[])$VALUES.clone();
        }

        public static TypeTag valueOf(String name) {
            return Enum.valueOf(TypeTag.class, name);
        }

        int encode(int offset) {
            int encoded = offset << 4 | this.ordinal() & 0xF;
            assert (TypeTag.getTag(encoded) == this && TypeTag.getOffset(encoded) == offset) : "error encoding type tag, maybe offset is too big?";
            return encoded;
        }

        static TypeTag getTag(int encoded) {
            return VALUES[encoded & 0xF];
        }

        static int getOffset(int encoded) {
            return encoded >>> 4;
        }

        static {
            $VALUES = new TypeTag[]{OBJECT, STRING, CLOSURE, ENV, BOOLEAN_ARRAY, BYTE_ARRAY, CHAR_ARRAY, SHORT_ARRAY, INT_ARRAY, LONG_ARRAY, FLOAT_ARRAY, DOUBLE_ARRAY};
            VALUES = TypeTag.values();
        }
    }
}

