/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.provider.EagerExportProvider;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.nfi.CallSignatureNode;
import com.oracle.truffle.nfi.CallSignatureNodeFactory;
import com.oracle.truffle.nfi.NFISymbol;
import com.oracle.truffle.nfi.api.NativePointerLibrary;
import com.oracle.truffle.nfi.backend.spi.BackendNativePointerLibrary;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=NFISymbol.class)
public final class NFISymbolGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<BackendNativePointerLibrary> BACKEND_NATIVE_POINTER_LIBRARY_ = LibraryFactory.resolve(BackendNativePointerLibrary.class);

    private NFISymbolGen() {
    }

    private static void init() {
    }

    static {
        LibraryExport.register(NFISymbol.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports(), new NativePointerLibraryExports()});
    }

    @GeneratedBy(value=NFISymbol.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, NFISymbol.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof NFISymbol);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof NFISymbol);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NFISymbol.class)
        @DenyReplace
        private static final class Uncached
        extends InteropLibrary {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFISymbol) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFISymbol;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol)receiver).isExecutable();
            }

            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                return arg0Value.execute(arg1Value, CallSignatureNodeFactory.CachedCallSignatureNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isNull(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                return arg0Value.isNull((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.nativeSymbol));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                return arg0Value.isPointerInterop((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.nativeSymbol));
            }

            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                return arg0Value.asPointerInterop((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.nativeSymbol));
            }

            @CompilerDirectives.TruffleBoundary
            public void toNative(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                arg0Value.toNative((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.nativeSymbol));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol)receiver).hasLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol)receiver).getLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol)receiver).toDisplayString(allowSideEffects);
            }
        }

        @GeneratedBy(value=NFISymbol.class)
        private static final class Cached
        extends InteropLibrary {
            @Node.Child
            private InteropLibrary receiverNativeSymbolInteropLibrary_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private CallSignatureNode.CachedCallSignatureNode executeNode__execute_call_;

            protected Cached(Object receiver) {
                NFISymbol castReceiver = (NFISymbol)receiver;
                this.receiverNativeSymbolInteropLibrary_ = (InteropLibrary)INTEROP_LIBRARY_.create(castReceiver.nativeSymbol);
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFISymbol) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof NFISymbol)) {
                    return false;
                }
                return this.receiverNativeSymbolInteropLibrary_.accepts(((NFISymbol)receiver).nativeSymbol);
            }

            public boolean isExecutable(Object receiver) {
                assert (receiver instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((NFISymbol)receiver).isExecutable();
            }

            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                CallSignatureNode.CachedCallSignatureNode call__;
                assert (arg0Value_ instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                int state_0 = this.state_0_;
                if (state_0 != 0 && (call__ = this.executeNode__execute_call_) != null) {
                    return arg0Value.execute(arg1Value, call__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object executeNode_AndSpecialize(NFISymbol arg0Value, Object[] arg1Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                int state_0 = this.state_0_;
                CallSignatureNode.CachedCallSignatureNode call__ = (CallSignatureNode.CachedCallSignatureNode)this.insert(CallSignatureNodeFactory.CachedCallSignatureNodeGen.create());
                Objects.requireNonNull(call__, "Specialization 'execute(NFISymbol, Object[], CachedCallSignatureNode)' cache 'call' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.executeNode__execute_call_ = call__;
                this.state_0_ = state_0 |= 1;
                return arg0Value.execute(arg1Value, call__);
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            public boolean isNull(Object arg0Value_) {
                assert (arg0Value_ instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                InteropLibrary library__ = this.receiverNativeSymbolInteropLibrary_;
                return arg0Value.isNull(library__);
            }

            public boolean isPointer(Object arg0Value_) {
                assert (arg0Value_ instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                InteropLibrary library__ = this.receiverNativeSymbolInteropLibrary_;
                return arg0Value.isPointerInterop(library__);
            }

            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (arg0Value_ instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                InteropLibrary library__ = this.receiverNativeSymbolInteropLibrary_;
                return arg0Value.asPointerInterop(library__);
            }

            public void toNative(Object arg0Value_) {
                assert (arg0Value_ instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                InteropLibrary library__ = this.receiverNativeSymbolInteropLibrary_;
                arg0Value.toNative(library__);
            }

            public boolean hasLanguage(Object receiver) {
                assert (receiver instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((NFISymbol)receiver).hasLanguage();
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (receiver instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((NFISymbol)receiver).getLanguage();
            }

            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (receiver instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((NFISymbol)receiver).toDisplayString(allowSideEffects);
            }
        }
    }

    @GeneratedBy(value=NFISymbol.class)
    private static final class NativePointerLibraryExports
    extends LibraryExport<NativePointerLibrary> {
        private NativePointerLibraryExports() {
            super(NativePointerLibrary.class, NFISymbol.class, false, true, 1);
        }

        protected NativePointerLibrary createUncached(Object receiver) {
            assert (receiver instanceof NFISymbol);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected NativePointerLibrary createCached(Object receiver) {
            assert (receiver instanceof NFISymbol || receiver instanceof LibraryExport);
            return new Cached();
        }

        @GeneratedBy(value=NFISymbol.class)
        @DenyReplace
        private static final class Uncached
        extends NativePointerLibrary {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFISymbol) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFISymbol;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                return arg0Value.isPointerNFI((BackendNativePointerLibrary)BACKEND_NATIVE_POINTER_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                return arg0Value.asPointerNFI((BackendNativePointerLibrary)BACKEND_NATIVE_POINTER_LIBRARY_.getUncached());
            }
        }

        @GeneratedBy(value=NFISymbol.class)
        private static final class Cached
        extends NativePointerLibrary
        implements GenerateAOT.Provider {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private BackendNativePointerLibrary backendNativePointer;

            protected Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFISymbol) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFISymbol;
            }

            @Override
            public boolean isPointer(Object arg0Value_) {
                BackendNativePointerLibrary backendNativePointer_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (NativePointerLibraryExports.assertAdopted((Node)((Node)this)));
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.isPointerNFINode_AndSpecialize(arg0Value);
                }
                if ((state_0 & 2) != 0 && (backendNativePointer_ = this.backendNativePointer) != null) {
                    return arg0Value.isPointerNFI(backendNativePointer_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isPointerNFINode_AndSpecialize(arg0Value);
            }

            private boolean isPointerNFINode_AndSpecialize(NFISymbol arg0Value) {
                BackendNativePointerLibrary backendNativePointer_;
                BackendNativePointerLibrary backendNativePointer__shared;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if ((backendNativePointer__shared = this.backendNativePointer) != null) {
                    backendNativePointer_ = backendNativePointer__shared;
                } else {
                    backendNativePointer_ = (BackendNativePointerLibrary)this.insert((Node)((BackendNativePointerLibrary)BACKEND_NATIVE_POINTER_LIBRARY_.createDispatched(1)));
                    if (backendNativePointer_ == null) {
                        throw new IllegalStateException("Specialization 'isPointerNFI(NFISymbol, BackendNativePointerLibrary)' contains a shared cache with name 'library' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.backendNativePointer == null) {
                    VarHandle.storeStoreFence();
                    this.backendNativePointer = backendNativePointer_;
                }
                this.state_0_ = state_0 |= 2;
                return arg0Value.isPointerNFI(backendNativePointer_);
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 2) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                BackendNativePointerLibrary backendNativePointer_1;
                BackendNativePointerLibrary backendNativePointer_;
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
                if ((this.state_0_ & 1) != 0) {
                    return;
                }
                BackendNativePointerLibrary backendNativePointer__shared = this.backendNativePointer;
                if (backendNativePointer__shared != null) {
                    backendNativePointer_ = backendNativePointer__shared;
                } else {
                    backendNativePointer_ = (BackendNativePointerLibrary)this.insert((Node)((BackendNativePointerLibrary)BACKEND_NATIVE_POINTER_LIBRARY_.createDispatched(1)));
                    if (backendNativePointer_ == null) {
                        throw new IllegalStateException("Specialization 'isPointerNFI(NFISymbol, BackendNativePointerLibrary)' contains a shared cache with name 'library' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.backendNativePointer == null) {
                    VarHandle.storeStoreFence();
                    this.backendNativePointer = backendNativePointer_;
                }
                if (this.backendNativePointer instanceof GenerateAOT.Provider) {
                    assert (NodeUtil.assertRecursion((Node)this.backendNativePointer, (int)1));
                    ((GenerateAOT.Provider)this.backendNativePointer).prepareForAOT(language, root);
                }
                this.state_0_ |= 2;
                BackendNativePointerLibrary backendNativePointer_1_shared = this.backendNativePointer;
                if (backendNativePointer_1_shared != null) {
                    backendNativePointer_1 = backendNativePointer_1_shared;
                } else {
                    backendNativePointer_1 = (BackendNativePointerLibrary)this.insert((Node)((BackendNativePointerLibrary)BACKEND_NATIVE_POINTER_LIBRARY_.createDispatched(1)));
                    if (backendNativePointer_1 == null) {
                        throw new IllegalStateException("Specialization 'asPointerNFI(NFISymbol, BackendNativePointerLibrary)' contains a shared cache with name 'library' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.backendNativePointer == null) {
                    VarHandle.storeStoreFence();
                    this.backendNativePointer = backendNativePointer_1;
                }
                if (this.backendNativePointer instanceof GenerateAOT.Provider) {
                    assert (NodeUtil.assertRecursion((Node)this.backendNativePointer, (int)1));
                    ((GenerateAOT.Provider)this.backendNativePointer).prepareForAOT(language, root);
                }
                this.state_0_ |= 4;
                int state_0 = this.state_0_;
                this.state_0_ = state_0 |= 1;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return;
                }
                this.state_0_ = 0;
                this.backendNativePointer = null;
                this.backendNativePointer = null;
            }

            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                BackendNativePointerLibrary backendNativePointer_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (NativePointerLibraryExports.assertAdopted((Node)((Node)this)));
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.asPointerNFINode_AndSpecialize(arg0Value);
                }
                if ((state_0 & 4) != 0 && (backendNativePointer_ = this.backendNativePointer) != null) {
                    return arg0Value.asPointerNFI(backendNativePointer_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asPointerNFINode_AndSpecialize(arg0Value);
            }

            private long asPointerNFINode_AndSpecialize(NFISymbol arg0Value) throws UnsupportedMessageException {
                BackendNativePointerLibrary backendNativePointer_;
                BackendNativePointerLibrary backendNativePointer__shared;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if ((backendNativePointer__shared = this.backendNativePointer) != null) {
                    backendNativePointer_ = backendNativePointer__shared;
                } else {
                    backendNativePointer_ = (BackendNativePointerLibrary)this.insert((Node)((BackendNativePointerLibrary)BACKEND_NATIVE_POINTER_LIBRARY_.createDispatched(1)));
                    if (backendNativePointer_ == null) {
                        throw new IllegalStateException("Specialization 'asPointerNFI(NFISymbol, BackendNativePointerLibrary)' contains a shared cache with name 'library' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.backendNativePointer == null) {
                    VarHandle.storeStoreFence();
                    this.backendNativePointer = backendNativePointer_;
                }
                this.state_0_ = state_0 |= 4;
                return arg0Value.asPointerNFI(backendNativePointer_);
            }
        }
    }

    @GeneratedBy(value=NFISymbol.class)
    public static final class NativePointerLibraryEagerProvider
    implements EagerExportProvider {
        public void ensureRegistered() {
            NFISymbolGen.init();
        }

        public String getLibraryClassName() {
            return "com.oracle.truffle.nfi.api.NativePointerLibrary";
        }
    }
}

