/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.nfi.backend.libffi.ClosureArgumentNode;
import com.oracle.truffle.nfi.backend.libffi.ClosureNativePointer;
import com.oracle.truffle.nfi.backend.libffi.LibFFIClosureFactory;
import com.oracle.truffle.nfi.backend.libffi.LibFFIContext;
import com.oracle.truffle.nfi.backend.libffi.LibFFILanguage;
import com.oracle.truffle.nfi.backend.libffi.LibFFISignature;
import com.oracle.truffle.nfi.backend.libffi.LibFFIType;
import com.oracle.truffle.nfi.backend.libffi.NativeArgumentBuffer;
import com.oracle.truffle.nfi.backend.libffi.NativeBuffer;
import com.oracle.truffle.nfi.backend.libffi.NativeString;
import com.oracle.truffle.nfi.backend.libffi.SerializeArgumentNode;

@ExportLibrary(value=InteropLibrary.class)
final class LibFFIClosure
implements TruffleObject {
    final ClosureNativePointer nativePointer;

    static LibFFIClosure newClosureWrapper(ClosureNativePointer nativePointer) {
        LibFFIClosure ret = new LibFFIClosure(nativePointer);
        ret.nativePointer.registerManagedRef(ret);
        return ret;
    }

    private LibFFIClosure(ClosureNativePointer nativePointer) {
        this.nativePointer = nativePointer;
    }

    @ExportMessage
    boolean isPointer() {
        return true;
    }

    @ExportMessage
    long asPointer() {
        return this.nativePointer.getCodePointer();
    }

    private static final class StringRetClosureRootNode
    extends RootNode {
        @Node.Child
        private CallClosureNode callClosure;
        @Node.Child
        private UnboxStringNode unboxString;

        static MonomorphicClosureInfo createInfo(LibFFILanguage lang, LibFFISignature.CachedSignatureInfo signatureInfo, Object receiver) {
            ClosureArgumentNode.ConstArgumentNode recvNode = new ClosureArgumentNode.ConstArgumentNode(receiver);
            StringRetClosureRootNode rootNode = new StringRetClosureRootNode(lang, signatureInfo, recvNode);
            return new MonomorphicClosureInfo(rootNode){

                @Override
                ClosureNativePointer allocateClosure(LibFFIContext ctx, LibFFISignature signature) {
                    return ctx.allocateClosureStringRet(signature, this.closureCallTarget, null);
                }
            };
        }

        static PolymorphicClosureInfo createInfo(LibFFILanguage lang, LibFFISignature.CachedSignatureInfo signatureInfo) {
            ClosureArgumentNode.GetArgumentNode recvNode = new ClosureArgumentNode.GetArgumentNode(signatureInfo.argTypes.length);
            StringRetClosureRootNode rootNode = new StringRetClosureRootNode(lang, signatureInfo, recvNode);
            return new PolymorphicClosureInfo(rootNode){

                @Override
                ClosureNativePointer allocateClosure(LibFFIContext ctx, LibFFISignature signature, Object receiver) {
                    return ctx.allocateClosureStringRet(signature, this.closureCallTarget, receiver);
                }
            };
        }

        private StringRetClosureRootNode(LibFFILanguage lang, LibFFISignature.CachedSignatureInfo signature, ClosureArgumentNode receiver) {
            super((TruffleLanguage)lang);
            this.callClosure = LibFFIClosureFactory.CallClosureNodeGen.create(signature, receiver);
            this.unboxString = LibFFIClosureFactory.UnboxStringNodeGen.create(signature.getRetType());
        }

        public Object execute(VirtualFrame frame) {
            Object ret = this.callClosure.execute(frame);
            try {
                return this.unboxString.execute(ret);
            }
            catch (UnsupportedTypeException ex) {
                return null;
            }
        }
    }

    static abstract class UnboxStringNode
    extends Node {
        @Node.Child
        SerializeArgumentNode serialize;

        UnboxStringNode(LibFFIType.CachedTypeInfo strType) {
            this.serialize = strType.createSerializeArgumentNode();
            assert (strType instanceof LibFFIType.StringType);
        }

        protected abstract Object execute(Object var1) throws UnsupportedTypeException;

        @Specialization
        protected Object nativeString(Object str) throws UnsupportedTypeException {
            RetStringBuffer retBuffer = new RetStringBuffer();
            CompilerDirectives.ensureVirtualized((Object)retBuffer);
            this.serialize.serialize(str, retBuffer);
            return retBuffer.ret;
        }
    }

    static final class RetStringBuffer
    extends NativeArgumentBuffer {
        Object ret;

        RetStringBuffer() {
            super(0);
        }

        @Override
        public int position() {
            return 0;
        }

        @Override
        public void position(int newPosition) {
            assert (newPosition == 0);
        }

        @Override
        public void putPointer(long ptr, int size) {
            assert (this.ret == null);
            this.ret = new NativeString(ptr);
        }

        @Override
        public void putObject(NativeArgumentBuffer.TypeTag tag, Object o, int size) {
            assert (this.ret == null);
            switch (tag) {
                case STRING: {
                    this.ret = o;
                    break;
                }
                case KEEPALIVE: {
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere((String)tag.name());
                }
            }
        }

        @Override
        public byte getInt8() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public void putInt8(byte b) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public short getInt16() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public void putInt16(short s) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public int getInt32() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public void putInt32(int i) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public long getInt64() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public void putInt64(long l) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public float getFloat() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public void putFloat(float f) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public double getDouble() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public void putDouble(double d) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public NativeBuffer get(int size) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }
    }

    private static final class NullableRetClosureRootNode
    extends RootNode {
        @Node.Child
        CallClosureNode callClosure;
        @Node.Child
        private InteropLibrary interopLibrary;

        static MonomorphicClosureInfo createInfo(LibFFILanguage lang, LibFFISignature.CachedSignatureInfo signatureInfo, Object receiver) {
            ClosureArgumentNode.ConstArgumentNode recvNode = new ClosureArgumentNode.ConstArgumentNode(receiver);
            NullableRetClosureRootNode rootNode = new NullableRetClosureRootNode(lang, signatureInfo, recvNode);
            return new MonomorphicClosureInfo(rootNode){

                @Override
                ClosureNativePointer allocateClosure(LibFFIContext ctx, LibFFISignature signature) {
                    return ctx.allocateClosureObjectRet(signature, this.closureCallTarget, null);
                }
            };
        }

        static PolymorphicClosureInfo createInfo(LibFFILanguage lang, LibFFISignature.CachedSignatureInfo signatureInfo) {
            ClosureArgumentNode.GetArgumentNode recvNode = new ClosureArgumentNode.GetArgumentNode(signatureInfo.argTypes.length);
            NullableRetClosureRootNode rootNode = new NullableRetClosureRootNode(lang, signatureInfo, recvNode);
            return new PolymorphicClosureInfo(rootNode){

                @Override
                ClosureNativePointer allocateClosure(LibFFIContext ctx, LibFFISignature signature, Object receiver) {
                    return ctx.allocateClosureObjectRet(signature, this.closureCallTarget, receiver);
                }
            };
        }

        private NullableRetClosureRootNode(LibFFILanguage lang, LibFFISignature.CachedSignatureInfo signature, ClosureArgumentNode receiver) {
            super((TruffleLanguage)lang);
            this.callClosure = LibFFIClosureFactory.CallClosureNodeGen.create(signature, receiver);
            this.interopLibrary = (InteropLibrary)InteropLibrary.getFactory().createDispatched(4);
        }

        public Object execute(VirtualFrame frame) {
            Object ret = this.callClosure.execute(frame);
            if (this.interopLibrary.isNull(ret)) {
                return null;
            }
            return ret;
        }
    }

    private static final class ObjectRetClosureRootNode
    extends RootNode {
        @Node.Child
        CallClosureNode callClosure;

        static MonomorphicClosureInfo createInfo(LibFFILanguage lang, LibFFISignature.CachedSignatureInfo signatureInfo, Object receiver) {
            ClosureArgumentNode.ConstArgumentNode recvNode = new ClosureArgumentNode.ConstArgumentNode(receiver);
            ObjectRetClosureRootNode rootNode = new ObjectRetClosureRootNode(lang, signatureInfo, recvNode);
            return new MonomorphicClosureInfo(rootNode){

                @Override
                ClosureNativePointer allocateClosure(LibFFIContext ctx, LibFFISignature signature) {
                    return ctx.allocateClosureObjectRet(signature, this.closureCallTarget, null);
                }
            };
        }

        static PolymorphicClosureInfo createInfo(LibFFILanguage lang, LibFFISignature.CachedSignatureInfo signatureInfo) {
            ClosureArgumentNode.GetArgumentNode recvNode = new ClosureArgumentNode.GetArgumentNode(signatureInfo.argTypes.length);
            ObjectRetClosureRootNode rootNode = new ObjectRetClosureRootNode(lang, signatureInfo, recvNode);
            return new PolymorphicClosureInfo(rootNode){

                @Override
                ClosureNativePointer allocateClosure(LibFFIContext ctx, LibFFISignature signature, Object receiver) {
                    return ctx.allocateClosureObjectRet(signature, this.closureCallTarget, receiver);
                }
            };
        }

        private ObjectRetClosureRootNode(LibFFILanguage lang, LibFFISignature.CachedSignatureInfo signature, ClosureArgumentNode receiver) {
            super((TruffleLanguage)lang);
            this.callClosure = LibFFIClosureFactory.CallClosureNodeGen.create(signature, receiver);
        }

        public Object execute(VirtualFrame frame) {
            return this.callClosure.execute(frame);
        }
    }

    private static final class VoidRetClosureRootNode
    extends RootNode {
        @Node.Child
        CallClosureNode callClosure;

        static MonomorphicClosureInfo createInfo(LibFFILanguage lang, LibFFISignature.CachedSignatureInfo signatureInfo, Object receiver) {
            ClosureArgumentNode.ConstArgumentNode recvNode = new ClosureArgumentNode.ConstArgumentNode(receiver);
            VoidRetClosureRootNode rootNode = new VoidRetClosureRootNode(lang, signatureInfo, recvNode);
            return new MonomorphicClosureInfo(rootNode){

                @Override
                ClosureNativePointer allocateClosure(LibFFIContext ctx, LibFFISignature signature) {
                    return ctx.allocateClosureVoidRet(signature, this.closureCallTarget, null);
                }
            };
        }

        static PolymorphicClosureInfo createInfo(LibFFILanguage lang, LibFFISignature.CachedSignatureInfo signatureInfo) {
            ClosureArgumentNode.GetArgumentNode recvNode = new ClosureArgumentNode.GetArgumentNode(signatureInfo.argTypes.length);
            VoidRetClosureRootNode rootNode = new VoidRetClosureRootNode(lang, signatureInfo, recvNode);
            return new PolymorphicClosureInfo(rootNode){

                @Override
                ClosureNativePointer allocateClosure(LibFFIContext ctx, LibFFISignature signature, Object receiver) {
                    return ctx.allocateClosureVoidRet(signature, this.closureCallTarget, receiver);
                }
            };
        }

        private VoidRetClosureRootNode(LibFFILanguage lang, LibFFISignature.CachedSignatureInfo signature, ClosureArgumentNode receiver) {
            super((TruffleLanguage)lang);
            this.callClosure = LibFFIClosureFactory.CallClosureNodeGen.create(signature, receiver);
        }

        public Object execute(VirtualFrame frame) {
            this.callClosure.execute(frame);
            return null;
        }
    }

    @NodeChild(value="retBuffer", type=ClosureArgumentNode.class)
    static abstract class BufferRetClosureRootNode
    extends RootNode {
        @Node.Child
        CallClosureNode callClosure;
        @Node.Child
        EncodeRetNode encodeRet;

        static MonomorphicClosureInfo createInfo(LibFFILanguage lang, LibFFISignature.CachedSignatureInfo signatureInfo, Object receiver) {
            ClosureArgumentNode.ConstArgumentNode recvNode = new ClosureArgumentNode.ConstArgumentNode(receiver);
            ClosureArgumentNode.GetArgumentNode retBuffer = new ClosureArgumentNode.GetArgumentNode(signatureInfo.argTypes.length);
            BufferRetClosureRootNode rootNode = LibFFIClosureFactory.BufferRetClosureRootNodeGen.create(lang, signatureInfo, recvNode, retBuffer);
            return new MonomorphicClosureInfo(rootNode){

                @Override
                ClosureNativePointer allocateClosure(LibFFIContext ctx, LibFFISignature signature) {
                    return ctx.allocateClosureBufferRet(signature, this.closureCallTarget, null);
                }
            };
        }

        static PolymorphicClosureInfo createInfo(LibFFILanguage lang, LibFFISignature.CachedSignatureInfo signatureInfo) {
            ClosureArgumentNode.GetArgumentNode recvNode = new ClosureArgumentNode.GetArgumentNode(signatureInfo.argTypes.length);
            ClosureArgumentNode.GetArgumentNode retBuffer = new ClosureArgumentNode.GetArgumentNode(signatureInfo.argTypes.length + 1);
            BufferRetClosureRootNode rootNode = LibFFIClosureFactory.BufferRetClosureRootNodeGen.create(lang, signatureInfo, recvNode, retBuffer);
            return new PolymorphicClosureInfo(rootNode){

                @Override
                ClosureNativePointer allocateClosure(LibFFIContext ctx, LibFFISignature signature, Object receiver) {
                    return ctx.allocateClosureBufferRet(signature, this.closureCallTarget, receiver);
                }
            };
        }

        BufferRetClosureRootNode(LibFFILanguage lang, LibFFISignature.CachedSignatureInfo signature, ClosureArgumentNode receiver) {
            super((TruffleLanguage)lang);
            this.callClosure = LibFFIClosureFactory.CallClosureNodeGen.create(signature, receiver);
            this.encodeRet = new EncodeRetNode(signature.getRetType());
        }

        @Specialization
        public Object doBufferRet(VirtualFrame frame, NativeArgumentBuffer.Pointer retBuffer) {
            Object ret = this.callClosure.execute(frame);
            return this.encodeRet.execute(ret, retBuffer);
        }
    }

    private static final class EncodeRetNode
    extends Node {
        private final LibFFIType.CachedTypeInfo retType;
        @Node.Child
        SerializeArgumentNode serialize;

        private EncodeRetNode(LibFFIType.CachedTypeInfo retType) {
            this.retType = retType;
            this.serialize = retType.createSerializeArgumentNode();
        }

        RetPatches execute(Object ret, NativeArgumentBuffer.Pointer retBuffer) {
            NativeArgumentBuffer.Direct nativeRetBuffer = new NativeArgumentBuffer.Direct(retBuffer, this.retType.objectCount);
            try {
                this.serialize.serialize(ret, nativeRetBuffer);
                if (nativeRetBuffer.getPatchCount() > 0) {
                    Object keepalive;
                    if (nativeRetBuffer.getPatchCount() == 1 && NativeArgumentBuffer.TypeTag.getTag(nativeRetBuffer.patches[0]) == NativeArgumentBuffer.TypeTag.KEEPALIVE && (keepalive = nativeRetBuffer.objects[0]) instanceof LibFFIClosure) {
                        ((LibFFIClosure)keepalive).nativePointer.addRef();
                        return null;
                    }
                    return new RetPatches(nativeRetBuffer.getPatchCount(), nativeRetBuffer.patches, nativeRetBuffer.objects);
                }
            }
            catch (UnsupportedTypeException unsupportedTypeException) {
                // empty catch block
            }
            return null;
        }
    }

    @NodeChild(value="receiver", type=ClosureArgumentNode.class)
    static abstract class CallClosureNode
    extends Node {
        @Node.Children
        final ClosureArgumentNode[] argNodes;

        protected abstract Object execute(VirtualFrame var1);

        CallClosureNode(LibFFISignature.CachedSignatureInfo signature) {
            LibFFIType.CachedTypeInfo[] args = signature.getArgTypes();
            this.argNodes = new ClosureArgumentNode[args.length];
            for (int i = 0; i < args.length; ++i) {
                ClosureArgumentNode.GetArgumentNode rawArg = new ClosureArgumentNode.GetArgumentNode(i);
                this.argNodes[i] = args[i].createClosureArgumentNode(rawArg);
            }
        }

        @Specialization(limit="3")
        @ExplodeLoop
        Object doCall(VirtualFrame frame, Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop) {
            Object[] args = new Object[this.argNodes.length];
            for (int i = 0; i < this.argNodes.length; ++i) {
                args[i] = this.argNodes[i].execute(frame);
            }
            try {
                return interop.execute(receiver, args);
            }
            catch (InteropException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }
    }

    static abstract class PolymorphicClosureInfo
    extends CachedClosureInfo {
        private PolymorphicClosureInfo(RootNode rootNode) {
            super(rootNode);
        }

        abstract ClosureNativePointer allocateClosure(LibFFIContext var1, LibFFISignature var2, Object var3);

        static PolymorphicClosureInfo create(LibFFISignature.CachedSignatureInfo signatureInfo) {
            CompilerAsserts.neverPartOfCompilation();
            LibFFILanguage lang = LibFFILanguage.get(null);
            LibFFIType.CachedTypeInfo retType = signatureInfo.getRetType();
            if (retType instanceof LibFFIType.ObjectType) {
                return ObjectRetClosureRootNode.createInfo(lang, signatureInfo);
            }
            if (retType instanceof LibFFIType.NullableType) {
                return NullableRetClosureRootNode.createInfo(lang, signatureInfo);
            }
            if (retType instanceof LibFFIType.StringType) {
                return StringRetClosureRootNode.createInfo(lang, signatureInfo);
            }
            if (retType instanceof LibFFIType.VoidType) {
                return VoidRetClosureRootNode.createInfo(lang, signatureInfo);
            }
            return BufferRetClosureRootNode.createInfo(lang, signatureInfo);
        }
    }

    static abstract class MonomorphicClosureInfo
    extends CachedClosureInfo {
        private MonomorphicClosureInfo(RootNode rootNode) {
            super(rootNode);
        }

        abstract ClosureNativePointer allocateClosure(LibFFIContext var1, LibFFISignature var2);

        static MonomorphicClosureInfo create(LibFFISignature.CachedSignatureInfo signatureInfo, Object executable) {
            CompilerAsserts.neverPartOfCompilation();
            LibFFILanguage lang = LibFFILanguage.get(null);
            LibFFIType.CachedTypeInfo retType = signatureInfo.getRetType();
            if (retType instanceof LibFFIType.ObjectType) {
                return ObjectRetClosureRootNode.createInfo(lang, signatureInfo, executable);
            }
            if (retType instanceof LibFFIType.NullableType) {
                return NullableRetClosureRootNode.createInfo(lang, signatureInfo, executable);
            }
            if (retType instanceof LibFFIType.StringType) {
                return StringRetClosureRootNode.createInfo(lang, signatureInfo, executable);
            }
            if (retType instanceof LibFFIType.VoidType) {
                return VoidRetClosureRootNode.createInfo(lang, signatureInfo, executable);
            }
            return BufferRetClosureRootNode.createInfo(lang, signatureInfo, executable);
        }
    }

    static abstract class CachedClosureInfo {
        final CallTarget closureCallTarget;

        CachedClosureInfo(RootNode rootNode) {
            this.closureCallTarget = rootNode.getCallTarget();
        }
    }

    static final class RetPatches {
        final int count;
        final int[] patches;
        final Object[] objects;

        RetPatches(int count, int[] patches, Object[] objects) {
            this.count = count;
            this.patches = patches;
            this.objects = objects;
        }
    }
}

