/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.api.InternalResource;
import com.oracle.truffle.runtime.LibTruffleAttachResource;
import java.lang.module.ModuleDescriptor;
import java.lang.reflect.Method;
import java.nio.file.Path;
import jdk.internal.module.Modules;

public final class ModulesSupport {
    private static final boolean ATTACH_AVAILABLE;

    private ModulesSupport() {
    }

    public static String exportJVMCI(Module module) {
        ModuleLayer layer = module.getLayer();
        if (layer == null) {
            if (ModulesSupport.class.getModule().getLayer() != null) {
                ModulesSupport.exportJVMCI(ModulesSupport.class);
            }
            return "Truffle was loaded from the class-path. Use Truffle from the module-path instead. Did you disable polyglot class-path isolation?";
        }
        Module jvmciModule = layer.findModule("jdk.internal.vm.ci").orElse(null);
        if (jvmciModule == null) {
            return "JVMCI is not enabled for this JVM. Enable JVMCI using -XX:+EnableJVMCI.";
        }
        if (!ATTACH_AVAILABLE) {
            return "The Truffle attach library is not available.";
        }
        ModulesSupport.addExportsRecursive(jvmciModule, module);
        return null;
    }

    public static String exportJVMCI(Class<?> toClass) {
        return ModulesSupport.exportJVMCI(toClass.getModule());
    }

    private static void addExportsRecursive(Module jvmciModule, Module runtimeModule) {
        for (String pn : jvmciModule.getPackages()) {
            ModulesSupport.addExports(jvmciModule, pn, runtimeModule);
        }
        for (ModuleDescriptor.Requires requires : runtimeModule.getDescriptor().requires()) {
            Module requiredModule = ModulesSupport.class.getModule().getLayer().findModule(requires.name()).orElse(null);
            if (requiredModule == null || requiredModule.getName().equals("java.base")) continue;
            ModulesSupport.addExportsRecursive(jvmciModule, requiredModule);
        }
    }

    public static void addExports(Module m1, String pn, Module m2) {
        if (!ATTACH_AVAILABLE) {
            throw new UnsupportedOperationException();
        }
        Modules.addExports(m1, pn, m2);
    }

    private static boolean loadModulesSupportLibrary() {
        String attachLibPath = System.getProperty("truffle.attach.library");
        try {
            if (attachLibPath == null) {
                Class<?> resourceCacheClass = Class.forName("com.oracle.truffle.polyglot.InternalResourceCache", false, ModulesSupport.class.getClassLoader());
                Method installRuntimeResource = resourceCacheClass.getDeclaredMethod("installRuntimeResource", InternalResource.class);
                installRuntimeResource.setAccessible(true);
                Path root = (Path)installRuntimeResource.invoke(null, new LibTruffleAttachResource());
                Path libAttach = root.resolve("bin").resolve(System.mapLibraryName("truffleattach"));
                attachLibPath = libAttach.toString();
            }
            System.load(attachLibPath);
            return true;
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }

    private static native void addExports0(Module var0, String var1, Module var2);

    static {
        Module moduleSupportModule = ModulesSupport.class.getModule();
        boolean bl = ATTACH_AVAILABLE = moduleSupportModule.isNamed() && ModulesSupport.loadModulesSupportLibrary();
        if (ATTACH_AVAILABLE) {
            ModulesSupport.addExports0(moduleSupportModule.getLayer().findModule("java.base").orElseThrow(), "jdk.internal.module", ModulesSupport.class.getModule());
        }
    }
}

