/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;
import org.hibernate.search.engine.backend.work.execution.spi.UnsupportedOperationBehavior;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeMappingContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoScopeWorkspace;
import org.hibernate.search.util.common.function.TriFunction;

public class PojoScopeWorkspaceImpl
implements PojoScopeWorkspace {
    private final List<IndexWorkspace> delegates = new ArrayList<IndexWorkspace>();

    public PojoScopeWorkspaceImpl(PojoScopeMappingContext mappingContext, Set<? extends PojoWorkIndexedTypeContext<?, ?>> targetedTypeContexts, Set<String> tenantIds) {
        for (PojoWorkIndexedTypeContext<?, ?> targetedTypeContext : targetedTypeContexts) {
            this.delegates.add(targetedTypeContext.createWorkspace(mappingContext, tenantIds));
        }
    }

    @Override
    public CompletableFuture<?> mergeSegments(OperationSubmitter operationSubmitter, UnsupportedOperationBehavior unsupportedOperationBehavior) {
        return this.doOperationOnTypes(IndexWorkspace::mergeSegments, operationSubmitter, unsupportedOperationBehavior);
    }

    @Override
    public CompletableFuture<?> purge(Set<String> routingKeys, OperationSubmitter operationSubmitter, UnsupportedOperationBehavior unsupportedOperationBehavior) {
        return this.doOperationOnTypes((indexWorkspace, submitter, unsupportedBehavior) -> indexWorkspace.purge(routingKeys, submitter, unsupportedBehavior), operationSubmitter, unsupportedOperationBehavior);
    }

    @Override
    public CompletableFuture<?> flush(OperationSubmitter operationSubmitter, UnsupportedOperationBehavior unsupportedOperationBehavior) {
        return this.doOperationOnTypes(IndexWorkspace::flush, operationSubmitter, unsupportedOperationBehavior);
    }

    @Override
    public CompletableFuture<?> refresh(OperationSubmitter operationSubmitter, UnsupportedOperationBehavior unsupportedOperationBehavior) {
        return this.doOperationOnTypes(IndexWorkspace::refresh, operationSubmitter, unsupportedOperationBehavior);
    }

    private CompletableFuture<?> doOperationOnTypes(TriFunction<IndexWorkspace, OperationSubmitter, UnsupportedOperationBehavior, CompletableFuture<?>> operation, OperationSubmitter operationSubmitter, UnsupportedOperationBehavior unsupportedOperationBehavior) {
        CompletableFuture[] futures = new CompletableFuture[this.delegates.size()];
        int typeCounter = 0;
        for (IndexWorkspace delegate : this.delegates) {
            futures[typeCounter++] = (CompletableFuture)operation.apply((Object)delegate, (Object)operationSubmitter, (Object)unsupportedOperationBehavior);
        }
        return CompletableFuture.allOf(futures);
    }
}

