/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.lang.annotation.ElementType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.engine.valueextraction.ArrayElement;
import org.hibernate.validator.internal.metadata.cascading.CascadingTypeParameter;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.TypeHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.xml.ContainerElementTypePath;
import org.hibernate.validator.internal.xml.GroupConversionBuilder;
import org.hibernate.validator.internal.xml.MetaConstraintBuilder;
import org.hibernate.validator.internal.xml.binding.ConstraintType;
import org.hibernate.validator.internal.xml.binding.ContainerElementTypeType;

class ContainerElementTypeConfigurationBuilder {
    private static final Log LOG = LoggerFactory.make();
    private final ConstraintLocation rootConstraintLocation;
    private final MetaConstraintBuilder metaConstraintBuilder;
    private final GroupConversionBuilder groupConversionBuilder;
    private final String defaultPackage;
    private final Set<ContainerElementTypePath> configuredPaths = new HashSet<ContainerElementTypePath>();

    ContainerElementTypeConfigurationBuilder(MetaConstraintBuilder metaConstraintBuilder, GroupConversionBuilder groupConversionBuilder, ConstraintLocation rootConstraintLocation, String defaultPackage) {
        this.metaConstraintBuilder = metaConstraintBuilder;
        this.groupConversionBuilder = groupConversionBuilder;
        this.rootConstraintLocation = rootConstraintLocation;
        this.defaultPackage = defaultPackage;
    }

    ContainerElementTypeConfiguration build(List<ContainerElementTypeType> xmlContainerElementTypes, Type enclosingType) {
        return this.add(ContainerElementTypePath.root(), xmlContainerElementTypes, this.rootConstraintLocation, enclosingType);
    }

    private ContainerElementTypeConfiguration add(ContainerElementTypePath parentConstraintElementTypePath, List<ContainerElementTypeType> xmlContainerElementTypes, ConstraintLocation parentConstraintLocation, Type enclosingType) {
        if (xmlContainerElementTypes.isEmpty()) {
            return new ContainerElementTypeConfiguration(Collections.emptySet(), Collections.emptyMap());
        }
        if (TypeHelper.isArray(enclosingType)) {
            throw LOG.getContainerElementConstraintsAndCascadedValidationNotSupportedOnArraysException(enclosingType);
        }
        if (!(enclosingType instanceof ParameterizedType) && !TypeHelper.isArray(enclosingType)) {
            throw LOG.getTypeIsNotAParameterizedNorArrayTypeException(enclosingType);
        }
        HashSet metaConstraints = new HashSet();
        HashMap<TypeVariable<?>, CascadingTypeParameter> containerElementTypesCascadingMetaData = CollectionHelper.newHashMap(xmlContainerElementTypes.size());
        boolean isArray = TypeHelper.isArray(enclosingType);
        TypeVariable[] typeParameters = isArray ? new TypeVariable[]{} : ReflectionHelper.getClassFromType(enclosingType).getTypeParameters();
        for (ContainerElementTypeType xmlContainerElementType : xmlContainerElementTypes) {
            boolean configuredBefore;
            Integer typeArgumentIndex = this.getTypeArgumentIndex(xmlContainerElementType, typeParameters, isArray, enclosingType);
            ContainerElementTypePath constraintElementTypePath = ContainerElementTypePath.of(parentConstraintElementTypePath, typeArgumentIndex);
            boolean bl = configuredBefore = !this.configuredPaths.add(constraintElementTypePath);
            if (configuredBefore) {
                throw LOG.getContainerElementTypeHasAlreadyBeenConfiguredViaXmlMappingConfigurationException(this.rootConstraintLocation, constraintElementTypePath);
            }
            TypeVariable<?> typeParameter = this.getTypeParameter(typeParameters, typeArgumentIndex, isArray, enclosingType);
            Type containerElementType = this.getContainerElementType(enclosingType, typeArgumentIndex, isArray);
            ConstraintLocation containerElementTypeConstraintLocation = ConstraintLocation.forTypeArgument(parentConstraintLocation, typeParameter, containerElementType);
            for (ConstraintType constraint : xmlContainerElementType.getConstraint()) {
                MetaConstraint metaConstraint = this.metaConstraintBuilder.buildMetaConstraint(containerElementTypeConstraintLocation, constraint, ElementType.TYPE_USE, this.defaultPackage, null);
                metaConstraints.add(metaConstraint);
            }
            ContainerElementTypeConfiguration nestedContainerElementTypeConfiguration = this.add(constraintElementTypePath, xmlContainerElementType.getContainerElementType(), containerElementTypeConstraintLocation, containerElementType);
            metaConstraints.addAll(nestedContainerElementTypeConfiguration.getMetaConstraints());
            boolean isCascaded = xmlContainerElementType.getValid() != null;
            containerElementTypesCascadingMetaData.put(typeParameter, new CascadingTypeParameter(enclosingType, typeParameter, isCascaded, nestedContainerElementTypeConfiguration.getTypeParametersCascadingMetaData(), this.groupConversionBuilder.buildGroupConversionMap(xmlContainerElementType.getConvertGroup(), this.defaultPackage)));
        }
        return new ContainerElementTypeConfiguration(metaConstraints, containerElementTypesCascadingMetaData);
    }

    private Integer getTypeArgumentIndex(ContainerElementTypeType xmlContainerElementType, TypeVariable<?>[] typeParameters, boolean isArray, Type enclosingType) {
        if (isArray) {
            return null;
        }
        Integer typeArgumentIndex = xmlContainerElementType.getTypeArgumentIndex();
        if (typeArgumentIndex == null) {
            if (typeParameters.length > 1) {
                throw LOG.getNoTypeArgumentIndexIsGivenForTypeWithMultipleTypeArgumentsException(enclosingType);
            }
            typeArgumentIndex = 0;
        }
        return typeArgumentIndex;
    }

    private TypeVariable<?> getTypeParameter(TypeVariable<?>[] typeParameters, Integer typeArgumentIndex, boolean isArray, Type enclosingType) {
        TypeVariable<Class<?>> typeParameter;
        if (!isArray) {
            if (typeArgumentIndex > typeParameters.length - 1) {
                throw LOG.getInvalidTypeArgumentIndexException(enclosingType, typeArgumentIndex);
            }
            typeParameter = typeParameters[typeArgumentIndex];
        } else {
            typeParameter = new ArrayElement(enclosingType);
        }
        return typeParameter;
    }

    private Type getContainerElementType(Type enclosingType, Integer typeArgumentIndex, boolean isArray) {
        Type containerElementType = !isArray ? ((ParameterizedType)enclosingType).getActualTypeArguments()[typeArgumentIndex] : TypeHelper.getComponentType(enclosingType);
        return containerElementType;
    }

    class ContainerElementTypeConfiguration {
        private final Set<MetaConstraint<?>> metaConstraints;
        private final Map<TypeVariable<?>, CascadingTypeParameter> containerElementTypesCascadingMetaData;

        private ContainerElementTypeConfiguration(Set<MetaConstraint<?>> metaConstraints, Map<TypeVariable<?>, CascadingTypeParameter> containerElementTypesCascadingMetaData) {
            this.metaConstraints = metaConstraints;
            this.containerElementTypesCascadingMetaData = containerElementTypesCascadingMetaData;
        }

        public Set<MetaConstraint<?>> getMetaConstraints() {
            return this.metaConstraints;
        }

        public Map<TypeVariable<?>, CascadingTypeParameter> getTypeParametersCascadingMetaData() {
            return this.containerElementTypesCascadingMetaData;
        }
    }
}

