/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.groups.Default;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.xml.ClassLoadingHelper;
import org.hibernate.validator.internal.xml.binding.GroupConversionType;

class GroupConversionBuilder {
    private static final Log LOG = LoggerFactory.make();
    private final ClassLoadingHelper classLoadingHelper;

    GroupConversionBuilder(ClassLoadingHelper classLoadingHelper) {
        this.classLoadingHelper = classLoadingHelper;
    }

    Map<Class<?>, Class<?>> buildGroupConversionMap(List<GroupConversionType> groupConversionTypes, String defaultPackage) {
        HashMap<Class<?>, Class<?>> groupConversionMap = CollectionHelper.newHashMap();
        for (GroupConversionType groupConversionType : groupConversionTypes) {
            Class<Default> fromClass = groupConversionType.getFrom() == null ? Default.class : this.classLoadingHelper.loadClass(groupConversionType.getFrom(), defaultPackage);
            Class<?> toClass = this.classLoadingHelper.loadClass(groupConversionType.getTo(), defaultPackage);
            if (groupConversionMap.containsKey(fromClass)) {
                throw LOG.getMultipleGroupConversionsForSameSourceException(fromClass, CollectionHelper.asSet((Class)groupConversionMap.get(fromClass), toClass));
            }
            groupConversionMap.put(fromClass, toClass);
        }
        return groupConversionMap;
    }
}

