/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.ResultSetReturn;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;

public class ResultSetReturnImpl
implements ResultSetReturn {
    private final JdbcCoordinator jdbcCoordinator;

    public ResultSetReturnImpl(JdbcCoordinator jdbcCoordinator) {
        this.jdbcCoordinator = jdbcCoordinator;
    }

    @Override
    public ResultSet extract(PreparedStatement statement) {
        if (statement instanceof CallableStatement) {
            CallableStatement callableStatement = (CallableStatement)statement;
            return this.extract(callableStatement);
        }
        try {
            ResultSet rs = statement.executeQuery();
            this.postExtract(rs, statement);
            return rs;
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper().convert(e, "could not extract ResultSet");
        }
    }

    @Override
    public ResultSet extract(CallableStatement statement) {
        try {
            ResultSet rs = this.jdbcCoordinator.getLogicalConnection().getJdbcServices().getDialect().getResultSet(statement);
            this.postExtract(rs, statement);
            return rs;
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper().convert(e, "could not extract ResultSet");
        }
    }

    @Override
    public ResultSet extract(Statement statement, String sql) {
        this.jdbcCoordinator.getLogicalConnection().getJdbcServices().getSqlStatementLogger().logStatement(sql);
        try {
            ResultSet rs = statement.executeQuery(sql);
            this.postExtract(rs, statement);
            return rs;
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper().convert(e, "could not extract ResultSet");
        }
    }

    @Override
    public ResultSet execute(PreparedStatement statement) {
        try {
            if (!statement.execute()) {
                while (!statement.getMoreResults() && statement.getUpdateCount() != -1) {
                }
            }
            ResultSet rs = statement.getResultSet();
            this.postExtract(rs, statement);
            return rs;
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper().convert(e, "could not execute statement");
        }
    }

    @Override
    public ResultSet execute(Statement statement, String sql) {
        this.jdbcCoordinator.getLogicalConnection().getJdbcServices().getSqlStatementLogger().logStatement(sql);
        try {
            if (!statement.execute(sql)) {
                while (!statement.getMoreResults() && statement.getUpdateCount() != -1) {
                }
            }
            ResultSet rs = statement.getResultSet();
            this.postExtract(rs, statement);
            return rs;
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper().convert(e, "could not execute statement");
        }
    }

    @Override
    public int executeUpdate(PreparedStatement statement) {
        try {
            return statement.executeUpdate();
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper().convert(e, "could not execute statement");
        }
    }

    @Override
    public int executeUpdate(Statement statement, String sql) {
        this.jdbcCoordinator.getLogicalConnection().getJdbcServices().getSqlStatementLogger().logStatement(sql);
        try {
            return statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper().convert(e, "could not execute statement");
        }
    }

    private final SqlExceptionHelper sqlExceptionHelper() {
        return this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().getTransactionEnvironment().getJdbcServices().getSqlExceptionHelper();
    }

    private void postExtract(ResultSet rs, Statement st) {
        if (rs != null) {
            this.jdbcCoordinator.register(rs, st);
        }
    }
}

