/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.entity.plan;

import java.io.Serializable;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.loader.entity.plan.AbstractBatchingEntityLoaderBuilder;
import org.hibernate.loader.entity.plan.BatchingEntityLoader;
import org.hibernate.loader.entity.plan.EntityLoader;
import org.hibernate.persister.entity.OuterJoinLoadable;

public class LegacyBatchingEntityLoaderBuilder
extends AbstractBatchingEntityLoaderBuilder {
    public static final LegacyBatchingEntityLoaderBuilder INSTANCE = new LegacyBatchingEntityLoaderBuilder();

    @Override
    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable persister, int batchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        return new LegacyBatchingEntityLoader(persister, batchSize, lockMode, factory, influencers);
    }

    @Override
    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable persister, int batchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        return new LegacyBatchingEntityLoader(persister, batchSize, lockOptions, factory, influencers);
    }

    public static class LegacyBatchingEntityLoader
    extends BatchingEntityLoader {
        private final int[] batchSizes;
        private final EntityLoader[] loaders;

        public LegacyBatchingEntityLoader(OuterJoinLoadable persister, int maxBatchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
            super(persister);
            this.batchSizes = ArrayHelper.getBatchSizes(maxBatchSize);
            this.loaders = new EntityLoader[this.batchSizes.length];
            EntityLoader.Builder entityLoaderBuilder = EntityLoader.forEntity(persister).withInfluencers(loadQueryInfluencers).withLockMode(lockMode);
            for (int i = 0; i < this.batchSizes.length; ++i) {
                this.loaders[i] = entityLoaderBuilder.withBatchSize(this.batchSizes[i]).byPrimaryKey();
            }
        }

        public LegacyBatchingEntityLoader(OuterJoinLoadable persister, int maxBatchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
            super(persister);
            this.batchSizes = ArrayHelper.getBatchSizes(maxBatchSize);
            this.loaders = new EntityLoader[this.batchSizes.length];
            EntityLoader.Builder entityLoaderBuilder = EntityLoader.forEntity(persister).withInfluencers(loadQueryInfluencers).withLockOptions(lockOptions);
            for (int i = 0; i < this.batchSizes.length; ++i) {
                this.loaders[i] = entityLoaderBuilder.withBatchSize(this.batchSizes[i]).byPrimaryKey();
            }
        }

        @Override
        public Object load(Serializable id, Object optionalObject, SessionImplementor session, LockOptions lockOptions) {
            Serializable[] batch = session.getPersistenceContext().getBatchFetchQueue().getEntityBatch(this.persister(), id, this.batchSizes[0], this.persister().getEntityMode());
            for (int i = 0; i < this.batchSizes.length - 1; ++i) {
                int smallBatchSize = this.batchSizes[i];
                if (batch[smallBatchSize - 1] == null) continue;
                Serializable[] smallBatch = new Serializable[smallBatchSize];
                System.arraycopy(batch, 0, smallBatch, 0, smallBatchSize);
                List results = this.loaders[i].loadEntityBatch(session, smallBatch, this.persister().getIdentifierType(), optionalObject, this.persister().getEntityName(), id, this.persister(), lockOptions);
                return this.getObjectFromList(results, id, session);
            }
            return this.loaders[this.batchSizes.length - 1].load(id, optionalObject, session, lockOptions);
        }
    }
}

