/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.spi;

import javassist.CtClass;
import javassist.CtField;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;

public class DefaultEnhancementContext
implements EnhancementContext {
    @Override
    public ClassLoader getLoadingClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Override
    public boolean isEntityClass(CtClass classDescriptor) {
        return classDescriptor.hasAnnotation(Entity.class);
    }

    @Override
    public boolean isCompositeClass(CtClass classDescriptor) {
        return classDescriptor.hasAnnotation(Embeddable.class);
    }

    @Override
    public boolean doBiDirectionalAssociationManagement(CtField field) {
        return true;
    }

    @Override
    public boolean doDirtyCheckingInline(CtClass classDescriptor) {
        return true;
    }

    @Override
    public boolean doExtendedEnhancement(CtClass classDescriptor) {
        return false;
    }

    @Override
    public boolean hasLazyLoadableAttributes(CtClass classDescriptor) {
        return true;
    }

    @Override
    public boolean isLazyLoadable(CtField field) {
        return true;
    }

    @Override
    public boolean isPersistentField(CtField ctField) {
        return !ctField.hasAnnotation(Transient.class);
    }

    @Override
    public boolean isMappedCollection(CtField field) {
        return field.hasAnnotation(OneToMany.class) || field.hasAnnotation(ManyToMany.class) || field.hasAnnotation(ElementCollection.class);
    }

    @Override
    public CtField[] order(CtField[] persistentFields) {
        return persistentFields;
    }
}

