/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.EntityMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoader;
import org.hibernate.bytecode.instrumentation.internal.FieldInterceptionHelper;
import org.hibernate.bytecode.instrumentation.spi.FieldInterceptor;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.cfg.Environment;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Subclass;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.PojoInstantiator;
import org.hibernate.tuple.entity.AbstractEntityTuplizer;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.CompositeType;

public class PojoEntityTuplizer
extends AbstractEntityTuplizer {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(PojoEntityTuplizer.class);
    private final Class mappedClass;
    private final Class proxyInterface;
    private final boolean lifecycleImplementor;
    private final Set<String> lazyPropertyNames;
    private final ReflectionOptimizer optimizer;
    private final boolean isInstrumented;

    public PojoEntityTuplizer(EntityMetamodel entityMetamodel, PersistentClass mappedEntity) {
        super(entityMetamodel, mappedEntity);
        this.mappedClass = mappedEntity.getMappedClass();
        this.proxyInterface = mappedEntity.getProxyInterface();
        this.lifecycleImplementor = Lifecycle.class.isAssignableFrom(this.mappedClass);
        this.isInstrumented = entityMetamodel.isInstrumented();
        Iterator iter = mappedEntity.getPropertyClosureIterator();
        HashSet<String> tmpLazyPropertyNames = new HashSet<String>();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            if (!property.isLazy()) continue;
            tmpLazyPropertyNames.add(property.getName());
        }
        this.lazyPropertyNames = tmpLazyPropertyNames.isEmpty() ? null : Collections.unmodifiableSet(tmpLazyPropertyNames);
        String[] getterNames = new String[this.propertySpan];
        String[] setterNames = new String[this.propertySpan];
        Class[] propTypes = new Class[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            getterNames[i] = this.getters[i].getMethodName();
            setterNames[i] = this.setters[i].getMethodName();
            propTypes[i] = this.getters[i].getReturnType();
        }
        this.optimizer = this.hasCustomAccessors || !Environment.useReflectionOptimizer() ? null : Environment.getBytecodeProvider().getReflectionOptimizer(this.mappedClass, getterNames, setterNames, propTypes);
    }

    @Override
    protected ProxyFactory buildProxyFactory(PersistentClass persistentClass, Getter idGetter, Setter idSetter) {
        LinkedHashSet<Class> proxyInterfaces = new LinkedHashSet<Class>();
        Class mappedClass = persistentClass.getMappedClass();
        Class proxyInterface = persistentClass.getProxyInterface();
        if (proxyInterface != null && !mappedClass.equals(proxyInterface)) {
            if (!proxyInterface.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + this.getEntityName());
            }
            proxyInterfaces.add(proxyInterface);
        }
        if (mappedClass.isInterface()) {
            proxyInterfaces.add(mappedClass);
        }
        Iterator subclasses = persistentClass.getSubclassIterator();
        while (subclasses.hasNext()) {
            Subclass subclass = (Subclass)subclasses.next();
            Class subclassProxy = subclass.getProxyInterface();
            Class subclassClass = subclass.getMappedClass();
            if (subclassProxy == null || subclassClass.equals(subclassProxy)) continue;
            if (!subclassProxy.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + subclass.getEntityName());
            }
            proxyInterfaces.add(subclassProxy);
        }
        proxyInterfaces.add(HibernateProxy.class);
        Iterator properties = persistentClass.getPropertyIterator();
        Class clazz = persistentClass.getMappedClass();
        while (properties.hasNext()) {
            Property property = (Property)properties.next();
            Method method = property.getGetter(clazz).getMethod();
            if (method != null && Modifier.isFinal(method.getModifiers())) {
                LOG.gettersOfLazyClassesCannotBeFinal(persistentClass.getEntityName(), property.getName());
            }
            if ((method = property.getSetter(clazz).getMethod()) == null || !Modifier.isFinal(method.getModifiers())) continue;
            LOG.settersOfLazyClassesCannotBeFinal(persistentClass.getEntityName(), property.getName());
        }
        Method idGetterMethod = idGetter == null ? null : idGetter.getMethod();
        Method idSetterMethod = idSetter == null ? null : idSetter.getMethod();
        Method proxyGetIdentifierMethod = idGetterMethod == null || proxyInterface == null ? null : ReflectHelper.getMethod(proxyInterface, idGetterMethod);
        Method proxySetIdentifierMethod = idSetterMethod == null || proxyInterface == null ? null : ReflectHelper.getMethod(proxyInterface, idSetterMethod);
        ProxyFactory pf = this.buildProxyFactoryInternal(persistentClass, idGetter, idSetter);
        try {
            pf.postInstantiate(this.getEntityName(), mappedClass, proxyInterfaces, proxyGetIdentifierMethod, proxySetIdentifierMethod, persistentClass.hasEmbeddedIdentifier() ? (CompositeType)persistentClass.getIdentifier().getType() : null);
        }
        catch (HibernateException he) {
            LOG.unableToCreateProxyFactory(this.getEntityName(), he);
            pf = null;
        }
        return pf;
    }

    protected ProxyFactory buildProxyFactoryInternal(PersistentClass persistentClass, Getter idGetter, Setter idSetter) {
        return Environment.getBytecodeProvider().getProxyFactoryFactory().buildProxyFactory(this.getFactory());
    }

    @Override
    protected Instantiator buildInstantiator(PersistentClass persistentClass) {
        if (this.optimizer == null) {
            return new PojoInstantiator(persistentClass, null);
        }
        return new PojoInstantiator(persistentClass, this.optimizer.getInstantiationOptimizer());
    }

    @Override
    public void setPropertyValues(Object entity, Object[] values) throws HibernateException {
        if (!this.getEntityMetamodel().hasLazyProperties() && this.optimizer != null && this.optimizer.getAccessOptimizer() != null) {
            this.setPropertyValuesWithOptimizer(entity, values);
        } else {
            super.setPropertyValues(entity, values);
        }
    }

    @Override
    public Object[] getPropertyValues(Object entity) throws HibernateException {
        if (this.shouldGetAllProperties(entity) && this.optimizer != null && this.optimizer.getAccessOptimizer() != null) {
            return this.getPropertyValuesWithOptimizer(entity);
        }
        return super.getPropertyValues(entity);
    }

    @Override
    public Object[] getPropertyValuesToInsert(Object entity, Map mergeMap, SessionImplementor session) throws HibernateException {
        if (this.shouldGetAllProperties(entity) && this.optimizer != null && this.optimizer.getAccessOptimizer() != null) {
            return this.getPropertyValuesWithOptimizer(entity);
        }
        return super.getPropertyValuesToInsert(entity, mergeMap, session);
    }

    protected void setPropertyValuesWithOptimizer(Object object, Object[] values) {
        this.optimizer.getAccessOptimizer().setPropertyValues(object, values);
    }

    protected Object[] getPropertyValuesWithOptimizer(Object object) {
        return this.optimizer.getAccessOptimizer().getPropertyValues(object);
    }

    @Override
    public EntityMode getEntityMode() {
        return EntityMode.POJO;
    }

    @Override
    public Class getMappedClass() {
        return this.mappedClass;
    }

    @Override
    public boolean isLifecycleImplementor() {
        return this.lifecycleImplementor;
    }

    @Override
    protected Getter buildPropertyGetter(Property mappedProperty, PersistentClass mappedEntity) {
        return mappedProperty.getGetter(mappedEntity.getMappedClass());
    }

    @Override
    protected Setter buildPropertySetter(Property mappedProperty, PersistentClass mappedEntity) {
        return mappedProperty.getSetter(mappedEntity.getMappedClass());
    }

    @Override
    public Class getConcreteProxyClass() {
        return this.proxyInterface;
    }

    @Override
    public void afterInitialize(Object entity, boolean lazyPropertiesAreUnfetched, SessionImplementor session) {
        if (this.isInstrumented()) {
            Set<String> lazyProps = lazyPropertiesAreUnfetched && this.getEntityMetamodel().hasLazyProperties() ? this.lazyPropertyNames : null;
            FieldInterceptionHelper.injectFieldInterceptor(entity, this.getEntityName(), lazyProps, session);
        }
        if (entity instanceof PersistentAttributeInterceptable && lazyPropertiesAreUnfetched && this.getEntityMetamodel().hasLazyProperties()) {
            LazyAttributeLoader interceptor = new LazyAttributeLoader(session, this.lazyPropertyNames, this.getEntityName());
            ((PersistentAttributeInterceptable)entity).$$_hibernate_setInterceptor(interceptor);
        }
        if (entity instanceof SelfDirtinessTracker) {
            ((SelfDirtinessTracker)entity).$$_hibernate_clearDirtyAttributes();
        }
    }

    @Override
    public boolean hasUninitializedLazyProperties(Object entity) {
        if (this.getEntityMetamodel().hasLazyProperties()) {
            PersistentAttributeInterceptor interceptor;
            if (entity instanceof PersistentAttributeInterceptable && (interceptor = ((PersistentAttributeInterceptable)entity).$$_hibernate_getInterceptor()) != null && interceptor instanceof LazyAttributeLoader) {
                return ((LazyAttributeLoader)interceptor).isUninitialized();
            }
            FieldInterceptor callback = FieldInterceptionHelper.extractFieldInterceptor(entity);
            return callback != null && !callback.isInitialized();
        }
        return false;
    }

    @Override
    public boolean isInstrumented() {
        return this.isInstrumented;
    }

    @Override
    public String determineConcreteSubclassEntityName(Object entityInstance, SessionFactoryImplementor factory) {
        Class<?> concreteEntityClass = entityInstance.getClass();
        if (concreteEntityClass == this.getMappedClass()) {
            return this.getEntityName();
        }
        String entityName = this.getEntityMetamodel().findEntityNameByEntityClass(concreteEntityClass);
        if (entityName == null) {
            throw new HibernateException("Unable to resolve entity name from Class [" + concreteEntityClass.getName() + "]" + " expected instance/subclass of [" + this.getEntityName() + "]");
        }
        return entityName;
    }

    @Override
    public EntityNameResolver[] getEntityNameResolvers() {
        return null;
    }
}

