/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.build.internal;

import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.spi.GraphNodeImplementor;
import org.hibernate.loader.plan.build.internal.AbstractEntityGraphVisitationStrategy;
import org.hibernate.persister.walking.spi.AssociationAttributeDefinition;

public class LoadGraphLoadPlanBuildingStrategy
extends AbstractEntityGraphVisitationStrategy {
    private final GraphNodeImplementor rootEntityGraph;

    public LoadGraphLoadPlanBuildingStrategy(SessionFactoryImplementor sessionFactory, LoadQueryInfluencers loadQueryInfluencers, LockMode lockMode) {
        super(sessionFactory, loadQueryInfluencers, lockMode);
        this.rootEntityGraph = (GraphNodeImplementor)loadQueryInfluencers.getLoadGraph();
    }

    @Override
    protected GraphNodeImplementor getRootEntityGraph() {
        return this.rootEntityGraph;
    }

    @Override
    protected FetchStrategy resolveImplicitFetchStrategyFromEntityGraph(AssociationAttributeDefinition attributeDefinition) {
        FetchStrategy fetchStrategy = attributeDefinition.determineFetchPlan(this.loadQueryInfluencers, this.currentPropertyPath);
        if (fetchStrategy.getTiming() == FetchTiming.IMMEDIATE && fetchStrategy.getStyle() == FetchStyle.JOIN) {
            fetchStrategy = this.adjustJoinFetchIfNeeded(attributeDefinition, fetchStrategy);
        }
        return fetchStrategy;
    }
}

