/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.boot.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.AttributeConverter;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.CacheRegionDefinition;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.archive.scan.internal.StandardScanOptions;
import org.hibernate.boot.cfgxml.internal.ConfigLoader;
import org.hibernate.boot.cfgxml.spi.CfgXmlAccessService;
import org.hibernate.boot.cfgxml.spi.LoadedConfig;
import org.hibernate.boot.cfgxml.spi.MappingReference;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.model.process.spi.ManagedResources;
import org.hibernate.boot.model.process.spi.MetadataBuildingProcess;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.internal.TcclLookupPrecedence;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.StrategyRegistrationProvider;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.MetadataBuilderImplementor;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryBuilderImplementor;
import org.hibernate.bytecode.enhance.spi.DefaultEnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.UnloadedClass;
import org.hibernate.bytecode.enhance.spi.UnloadedField;
import org.hibernate.cfg.AttributeConverterDefinition;
import org.hibernate.cfg.beanvalidation.BeanValidationIntegrator;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.factory.spi.MutableIdentifierGeneratorFactory;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.HEMLogging;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jpa.boot.internal.StandardJpaScanEnvironmentImpl;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.jpa.boot.spi.IntegratorProvider;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.jpa.boot.spi.StrategyRegistrationProviderList;
import org.hibernate.jpa.boot.spi.TypeContributorList;
import org.hibernate.jpa.event.spi.JpaIntegrator;
import org.hibernate.jpa.internal.util.LogHelper;
import org.hibernate.jpa.internal.util.PersistenceUnitTransactionTypeHelper;
import org.hibernate.jpa.spi.IdentifierGeneratorStrategyProvider;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.resource.transaction.backend.jdbc.internal.JdbcResourceLocalTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionCoordinatorBuilderImpl;
import org.hibernate.secure.spi.GrantedPermission;
import org.hibernate.secure.spi.JaccPermissionDeclarations;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.schema.spi.DelayedDropRegistryNotAvailableImpl;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;

public class EntityManagerFactoryBuilderImpl
implements EntityManagerFactoryBuilder {
    private static final EntityManagerMessageLogger LOG = HEMLogging.messageLogger(EntityManagerFactoryBuilderImpl.class);
    public static final String INTEGRATOR_PROVIDER = "hibernate.integrator_provider";
    public static final String STRATEGY_REGISTRATION_PROVIDERS = "hibernate.strategy_registration_provider";
    public static final String TYPE_CONTRIBUTORS = "hibernate.type_contributors";
    public static final String JANDEX_INDEX = "hibernate.jandex_index";
    private final PersistenceUnitDescriptor persistenceUnit;
    private final Map configurationValues;
    private final StandardServiceRegistry standardServiceRegistry;
    private final ManagedResources managedResources;
    private final MetadataBuilderImplementor metamodelBuilder;
    private Object validatorFactory;
    private Object cdiBeanManager;
    private DataSource dataSource;
    private MetadataImplementor metadata;

    public EntityManagerFactoryBuilderImpl(PersistenceUnitDescriptor persistenceUnit, Map integrationSettings) {
        this(persistenceUnit, integrationSettings, null, null);
    }

    public EntityManagerFactoryBuilderImpl(PersistenceUnitDescriptor persistenceUnit, Map integrationSettings, ClassLoader providedClassLoader) {
        this(persistenceUnit, integrationSettings, providedClassLoader, null);
    }

    public EntityManagerFactoryBuilderImpl(PersistenceUnitDescriptor persistenceUnit, Map integrationSettings, ClassLoaderService providedClassLoaderService) {
        this(persistenceUnit, integrationSettings, null, providedClassLoaderService);
    }

    private EntityManagerFactoryBuilderImpl(PersistenceUnitDescriptor persistenceUnit, Map integrationSettings, ClassLoader providedClassLoader, ClassLoaderService providedClassLoaderService) {
        LogHelper.logPersistenceUnitInformation(persistenceUnit);
        this.persistenceUnit = persistenceUnit;
        if (integrationSettings == null) {
            integrationSettings = Collections.emptyMap();
        }
        BootstrapServiceRegistry bsr = this.buildBootstrapServiceRegistry(integrationSettings, providedClassLoader, providedClassLoaderService);
        StandardServiceRegistryBuilder ssrBuilder = new StandardServiceRegistryBuilder(bsr);
        MergedSettings mergedSettings = this.mergeSettings(persistenceUnit, integrationSettings, ssrBuilder);
        this.configurationValues = mergedSettings.getConfigurationValues();
        ssrBuilder.applySettings(this.configurationValues);
        this.configure(ssrBuilder);
        this.standardServiceRegistry = ssrBuilder.build();
        this.configure(this.standardServiceRegistry, mergedSettings);
        MetadataSources metadataSources = new MetadataSources(bsr);
        List<AttributeConverterDefinition> attributeConverterDefinitions = this.populate(metadataSources, mergedSettings, this.standardServiceRegistry);
        this.metamodelBuilder = (MetadataBuilderImplementor)metadataSources.getMetadataBuilder(this.standardServiceRegistry);
        this.populate(this.metamodelBuilder, mergedSettings, this.standardServiceRegistry, attributeConverterDefinitions);
        CfgXmlAccessService cfgXmlAccessService = this.standardServiceRegistry.getService(CfgXmlAccessService.class);
        if (cfgXmlAccessService.getAggregatedConfig() != null && cfgXmlAccessService.getAggregatedConfig().getMappingReferences() != null) {
            for (MappingReference mappingReference : cfgXmlAccessService.getAggregatedConfig().getMappingReferences()) {
                mappingReference.apply(metadataSources);
            }
        }
        this.managedResources = MetadataBuildingProcess.prepare(metadataSources, this.metamodelBuilder.getMetadataBuildingOptions());
        this.withValidatorFactory(this.configurationValues.get("javax.persistence.validation.factory"));
        boolean dirtyTrackingEnabled = this.readBooleanConfigurationValue("hibernate.enhancer.enableDirtyTracking");
        boolean lazyInitializationEnabled = this.readBooleanConfigurationValue("hibernate.enhancer.enableLazyInitialization");
        boolean associationManagementEnabled = this.readBooleanConfigurationValue("hibernate.enhancer.enableAssociationManagement");
        if (dirtyTrackingEnabled || lazyInitializationEnabled || associationManagementEnabled) {
            EnhancementContext enhancementContext = this.getEnhancementContext(dirtyTrackingEnabled, lazyInitializationEnabled, associationManagementEnabled);
            persistenceUnit.pushClassTransformer(enhancementContext);
        }
        this.metamodelBuilder.applyTempClassLoader(null);
    }

    public Map getConfigurationValues() {
        return Collections.unmodifiableMap(this.configurationValues);
    }

    private boolean readBooleanConfigurationValue(String propertyName) {
        Object propertyValue = this.configurationValues.remove(propertyName);
        return propertyValue != null && Boolean.parseBoolean(propertyValue.toString());
    }

    protected EnhancementContext getEnhancementContext(final boolean dirtyTrackingEnabled, final boolean lazyInitializationEnabled, final boolean associationManagementEnabled) {
        return new DefaultEnhancementContext(){

            @Override
            public boolean isEntityClass(UnloadedClass classDescriptor) {
                return EntityManagerFactoryBuilderImpl.this.managedResources.getAnnotatedClassNames().contains(classDescriptor.getName()) && super.isEntityClass(classDescriptor);
            }

            @Override
            public boolean isCompositeClass(UnloadedClass classDescriptor) {
                return EntityManagerFactoryBuilderImpl.this.managedResources.getAnnotatedClassNames().contains(classDescriptor.getName()) && super.isCompositeClass(classDescriptor);
            }

            @Override
            public boolean doBiDirectionalAssociationManagement(UnloadedField field) {
                return associationManagementEnabled;
            }

            @Override
            public boolean doDirtyCheckingInline(UnloadedClass classDescriptor) {
                return dirtyTrackingEnabled;
            }

            @Override
            public boolean hasLazyLoadableAttributes(UnloadedClass classDescriptor) {
                return lazyInitializationEnabled;
            }

            @Override
            public boolean isLazyLoadable(UnloadedField field) {
                return lazyInitializationEnabled;
            }

            @Override
            public boolean doExtendedEnhancement(UnloadedClass classDescriptor) {
                return false;
            }
        };
    }

    private BootstrapServiceRegistry buildBootstrapServiceRegistry(Map integrationSettings, ClassLoader providedClassLoader, ClassLoaderService providedClassLoaderService) {
        StrategyRegistrationProviderList strategyRegistrationProviderList;
        BootstrapServiceRegistryBuilder bsrBuilder = new BootstrapServiceRegistryBuilder();
        bsrBuilder.applyIntegrator(new JpaIntegrator());
        IntegratorProvider integratorProvider = (IntegratorProvider)integrationSettings.get(INTEGRATOR_PROVIDER);
        if (integratorProvider != null) {
            for (Integrator integrator : integratorProvider.getIntegrators()) {
                bsrBuilder.applyIntegrator(integrator);
            }
        }
        if ((strategyRegistrationProviderList = (StrategyRegistrationProviderList)integrationSettings.get(STRATEGY_REGISTRATION_PROVIDERS)) != null) {
            for (StrategyRegistrationProvider strategyRegistrationProvider : strategyRegistrationProviderList.getStrategyRegistrationProviders()) {
                bsrBuilder.applyStrategySelectors(strategyRegistrationProvider);
            }
        }
        if (providedClassLoaderService != null) {
            bsrBuilder.applyClassLoaderService(providedClassLoaderService);
        } else {
            String tcclLookupPrecedence;
            Properties puProperties;
            Object classLoadersSetting;
            ClassLoader classLoader;
            if (this.persistenceUnit.getClassLoader() != null) {
                bsrBuilder.applyClassLoader(this.persistenceUnit.getClassLoader());
            }
            if (providedClassLoader != null) {
                bsrBuilder.applyClassLoader(providedClassLoader);
            }
            if ((classLoader = (ClassLoader)integrationSettings.get("hibernate.classLoader.application")) != null) {
                LOG.debugf("Found use of deprecated `%s` setting; use `%s` instead.", "hibernate.classLoader.application", "hibernate.classLoaders");
            }
            if ((classLoadersSetting = integrationSettings.get("hibernate.classLoaders")) != null) {
                if (Collection.class.isInstance(classLoadersSetting)) {
                    for (ClassLoader classLoader2 : (Collection)classLoadersSetting) {
                        bsrBuilder.applyClassLoader(classLoader2);
                    }
                } else if (classLoadersSetting.getClass().isArray()) {
                    for (ClassLoader classLoader3 : (ClassLoader[])classLoadersSetting) {
                        bsrBuilder.applyClassLoader(classLoader3);
                    }
                } else if (ClassLoader.class.isInstance(classLoadersSetting)) {
                    bsrBuilder.applyClassLoader((ClassLoader)classLoadersSetting);
                }
            }
            if ((puProperties = this.persistenceUnit.getProperties()) != null && (tcclLookupPrecedence = puProperties.getProperty("hibernate.classLoader.tccl_lookup_precedence")) != null) {
                bsrBuilder.applyTcclLookupPrecedence(TcclLookupPrecedence.valueOf(tcclLookupPrecedence.toUpperCase(Locale.ROOT)));
            }
        }
        return bsrBuilder.build();
    }

    private MergedSettings mergeSettings(PersistenceUnitDescriptor persistenceUnit, Map<?, ?> integrationSettings, StandardServiceRegistryBuilder ssrBuilder) {
        String cfgXmlResourceName2;
        MergedSettings mergedSettings = new MergedSettings();
        if (persistenceUnit.getProperties() != null) {
            mergedSettings.configurationValues.putAll(persistenceUnit.getProperties());
        }
        mergedSettings.configurationValues.put("hibernate.ejb.persistenceUnitName", persistenceUnit.getName());
        ConfigLoader configLoader = new ConfigLoader(ssrBuilder.getBootstrapServiceRegistry());
        String cfgXmlResourceName1 = (String)mergedSettings.configurationValues.remove("hibernate.ejb.cfgfile");
        if (StringHelper.isNotEmpty(cfgXmlResourceName1)) {
            LoadedConfig loadedCfg = configLoader.loadConfigXmlResource(cfgXmlResourceName1);
            this.processConfigXml(loadedCfg, mergedSettings, ssrBuilder);
        }
        if (StringHelper.isNotEmpty(cfgXmlResourceName2 = (String)integrationSettings.get("hibernate.ejb.cfgfile"))) {
            integrationSettings.remove("hibernate.ejb.cfgfile");
            LoadedConfig loadedCfg = configLoader.loadConfigXmlResource(cfgXmlResourceName2);
            this.processConfigXml(loadedCfg, mergedSettings, ssrBuilder);
        }
        for (Map.Entry entry : integrationSettings.entrySet()) {
            if (entry.getKey() == null) continue;
            if (entry.getValue() == null) {
                mergedSettings.configurationValues.remove(entry.getKey());
                continue;
            }
            mergedSettings.configurationValues.put(entry.getKey(), entry.getValue());
        }
        if (!mergedSettings.configurationValues.containsKey("javax.persistence.validation.mode") && persistenceUnit.getValidationMode() != null) {
            mergedSettings.configurationValues.put("javax.persistence.validation.mode", persistenceUnit.getValidationMode());
        }
        if (!mergedSettings.configurationValues.containsKey("javax.persistence.sharedCache.mode") && persistenceUnit.getSharedCacheMode() != null) {
            mergedSettings.configurationValues.put("javax.persistence.sharedCache.mode", persistenceUnit.getSharedCacheMode());
        }
        String jaccContextId = (String)mergedSettings.configurationValues.get("hibernate.jacc_context_id");
        Iterator iterator = mergedSettings.configurationValues.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() == null) {
                iterator.remove();
                break;
            }
            if (!String.class.isInstance(entry.getKey()) || !String.class.isInstance(entry.getValue())) continue;
            String keyString = (String)entry.getKey();
            String valueString = (String)entry.getValue();
            if (keyString.startsWith("hibernate.jacc")) {
                if ("hibernate.jacc_context_id".equals(keyString) || "hibernate.jacc.enabled".equals(keyString)) continue;
                if (jaccContextId == null) {
                    LOG.debug("Found JACC permission grant [%s] in properties, but no JACC context id was specified; ignoring");
                    continue;
                }
                mergedSettings.getJaccPermissions(jaccContextId).addPermissionDeclaration(this.parseJaccConfigEntry(keyString, valueString));
                continue;
            }
            if (keyString.startsWith("hibernate.ejb.classcache")) {
                mergedSettings.addCacheRegionDefinition(this.parseCacheRegionDefinitionEntry(keyString.substring("hibernate.ejb.classcache".length() + 1), valueString, CacheRegionDefinition.CacheRegionType.ENTITY));
                continue;
            }
            if (!keyString.startsWith("hibernate.ejb.collectioncache")) continue;
            mergedSettings.addCacheRegionDefinition(this.parseCacheRegionDefinitionEntry(keyString.substring("hibernate.ejb.collectioncache".length() + 1), (String)entry.getValue(), CacheRegionDefinition.CacheRegionType.COLLECTION));
        }
        return mergedSettings;
    }

    private void processConfigXml(LoadedConfig loadedConfig, MergedSettings mergedSettings, StandardServiceRegistryBuilder ssrBuilder) {
        String sfName;
        if (!mergedSettings.configurationValues.containsKey("hibernate.session_factory_name") && (sfName = loadedConfig.getSessionFactoryName()) != null) {
            mergedSettings.configurationValues.put("hibernate.session_factory_name", sfName);
        }
        mergedSettings.configurationValues.putAll(loadedConfig.getConfigurationValues());
        ssrBuilder.configure(loadedConfig);
    }

    private GrantedPermission parseJaccConfigEntry(String keyString, String valueString) {
        try {
            int roleStart = "hibernate.jacc".length() + 1;
            String role = keyString.substring(roleStart, keyString.indexOf(46, roleStart));
            int classStart = roleStart + role.length() + 1;
            String clazz = keyString.substring(classStart, keyString.length());
            return new GrantedPermission(role, clazz, valueString);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.persistenceException("Illegal usage of hibernate.jacc: " + keyString);
        }
    }

    private CacheRegionDefinition parseCacheRegionDefinitionEntry(String role, String value, CacheRegionDefinition.CacheRegionType cacheType) {
        StringTokenizer params = new StringTokenizer(value, ";, ");
        if (!params.hasMoreTokens()) {
            StringBuilder error = new StringBuilder("Illegal usage of ");
            if (cacheType == CacheRegionDefinition.CacheRegionType.ENTITY) {
                error.append("hibernate.ejb.classcache").append(": ").append("hibernate.ejb.classcache");
            } else {
                error.append("hibernate.ejb.collectioncache").append(": ").append("hibernate.ejb.collectioncache");
            }
            error.append('.').append(role).append(' ').append(value).append(".  Was expecting configuration (usage[,region[,lazy]]), but found none");
            throw this.persistenceException(error.toString());
        }
        String usage = params.nextToken();
        String region = null;
        if (params.hasMoreTokens()) {
            region = params.nextToken();
        }
        boolean lazyProperty = true;
        if (cacheType == CacheRegionDefinition.CacheRegionType.ENTITY) {
            if (params.hasMoreTokens()) {
                lazyProperty = "all".equalsIgnoreCase(params.nextToken());
            }
        } else {
            lazyProperty = false;
        }
        return new CacheRegionDefinition(cacheType, role, usage, region, lazyProperty);
    }

    private void configure(StandardServiceRegistryBuilder ssrBuilder) {
        this.applyJdbcConnectionProperties(ssrBuilder);
        this.applyTransactionProperties(ssrBuilder);
        if ("true".equals(this.configurationValues.get("hibernate.transaction.flush_before_completion"))) {
            ssrBuilder.applySetting("hibernate.transaction.flush_before_completion", "false");
            LOG.definingFlushBeforeCompletionIgnoredInHem("hibernate.transaction.flush_before_completion");
        }
    }

    private void applyJdbcConnectionProperties(StandardServiceRegistryBuilder ssrBuilder) {
        if (this.dataSource != null) {
            ssrBuilder.applySetting("hibernate.connection.datasource", this.dataSource);
        } else if (this.persistenceUnit.getJtaDataSource() != null) {
            if (!ssrBuilder.getSettings().containsKey("hibernate.connection.datasource")) {
                ssrBuilder.applySetting("hibernate.connection.datasource", this.persistenceUnit.getJtaDataSource());
                this.configurationValues.put("javax.persistence.jtaDataSource", this.persistenceUnit.getJtaDataSource());
            }
        } else if (this.persistenceUnit.getNonJtaDataSource() != null) {
            if (!ssrBuilder.getSettings().containsKey("hibernate.connection.datasource")) {
                ssrBuilder.applySetting("hibernate.connection.datasource", this.persistenceUnit.getNonJtaDataSource());
                this.configurationValues.put("javax.persistence.nonJtaDataSource", this.persistenceUnit.getNonJtaDataSource());
            }
        } else {
            String pass;
            String user;
            String url;
            String driver = (String)this.configurationValues.get("javax.persistence.jdbc.driver");
            if (StringHelper.isNotEmpty(driver)) {
                ssrBuilder.applySetting("hibernate.connection.driver_class", driver);
            }
            if (StringHelper.isNotEmpty(url = (String)this.configurationValues.get("javax.persistence.jdbc.url"))) {
                ssrBuilder.applySetting("hibernate.connection.url", url);
            }
            if (StringHelper.isNotEmpty(user = (String)this.configurationValues.get("javax.persistence.jdbc.user"))) {
                ssrBuilder.applySetting("hibernate.connection.username", user);
            }
            if (StringHelper.isNotEmpty(pass = (String)this.configurationValues.get("javax.persistence.jdbc.password"))) {
                ssrBuilder.applySetting("hibernate.connection.password", pass);
            }
        }
    }

    private void applyTransactionProperties(StandardServiceRegistryBuilder ssrBuilder) {
        boolean hasTxStrategy;
        PersistenceUnitTransactionType txnType = PersistenceUnitTransactionTypeHelper.interpretTransactionType(this.configurationValues.get("javax.persistence.transactionType"));
        if (txnType == null) {
            txnType = this.persistenceUnit.getTransactionType();
        }
        if (txnType == null) {
            txnType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        if (hasTxStrategy = this.configurationValues.containsKey("hibernate.transaction.coordinator_class")) {
            LOG.overridingTransactionStrategyDangerous("hibernate.transaction.coordinator_class");
        } else if (txnType == PersistenceUnitTransactionType.JTA) {
            ssrBuilder.applySetting("hibernate.transaction.coordinator_class", JtaTransactionCoordinatorBuilderImpl.class);
        } else if (txnType == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
            ssrBuilder.applySetting("hibernate.transaction.coordinator_class", JdbcResourceLocalTransactionCoordinatorBuilderImpl.class);
        }
    }

    private void configure(StandardServiceRegistry ssr, MergedSettings mergedSettings) {
        StrategySelector strategySelector = ssr.getService(StrategySelector.class);
        Object idGeneratorStrategyProviderSetting = this.configurationValues.remove("hibernate.ejb.identifier_generator_strategy_provider");
        if (idGeneratorStrategyProviderSetting != null) {
            IdentifierGeneratorStrategyProvider idGeneratorStrategyProvider = strategySelector.resolveStrategy(IdentifierGeneratorStrategyProvider.class, idGeneratorStrategyProviderSetting);
            MutableIdentifierGeneratorFactory identifierGeneratorFactory = ssr.getService(MutableIdentifierGeneratorFactory.class);
            if (identifierGeneratorFactory == null) {
                throw this.persistenceException("Application requested custom identifier generator strategies, but the MutableIdentifierGeneratorFactory could not be found");
            }
            for (Map.Entry<String, Class<?>> entry : idGeneratorStrategyProvider.getStrategies().entrySet()) {
                identifierGeneratorFactory.register(entry.getKey(), entry.getValue());
            }
        }
    }

    protected List<AttributeConverterDefinition> populate(MetadataSources metadataSources, MergedSettings mergedSettings, StandardServiceRegistry ssr) {
        List explicitOrmXmlList;
        String explicitHbmXmls;
        ArrayList<AttributeConverterDefinition> attributeConverterDefinitions = null;
        List loadedAnnotatedClasses = (List)this.configurationValues.remove("hibernate.ejb.loaded.classes");
        if (loadedAnnotatedClasses != null) {
            for (String[] cls : loadedAnnotatedClasses) {
                if (AttributeConverter.class.isAssignableFrom((Class<?>)cls)) {
                    if (attributeConverterDefinitions == null) {
                        attributeConverterDefinitions = new ArrayList<AttributeConverterDefinition>();
                    }
                    attributeConverterDefinitions.add(AttributeConverterDefinition.from((Class<? extends AttributeConverter>)cls));
                    continue;
                }
                metadataSources.addAnnotatedClass((Class)cls);
            }
        }
        if ((explicitHbmXmls = (String)this.configurationValues.remove("hibernate.hbmxml.files")) != null) {
            for (String hbmXml : StringHelper.split(", ", explicitHbmXmls)) {
                metadataSources.addResource(hbmXml);
            }
        }
        if ((explicitOrmXmlList = (List)this.configurationValues.remove("hibernate.ejb.xml_files")) != null) {
            for (String ormXml : explicitOrmXmlList) {
                metadataSources.addResource(ormXml);
            }
        }
        return attributeConverterDefinitions;
    }

    protected void populate(MetadataBuilder metamodelBuilder, MergedSettings mergedSettings, StandardServiceRegistry ssr, List<AttributeConverterDefinition> attributeConverterDefinitions) {
        TypeContributorList typeContributorList;
        if (this.persistenceUnit.getTempClassLoader() != null) {
            metamodelBuilder.applyTempClassLoader(this.persistenceUnit.getTempClassLoader());
        }
        metamodelBuilder.applyScanEnvironment(new StandardJpaScanEnvironmentImpl(this.persistenceUnit));
        metamodelBuilder.applyScanOptions(new StandardScanOptions((String)this.configurationValues.get("hibernate.archive.autodetection"), this.persistenceUnit.isExcludeUnlistedClasses()));
        if (mergedSettings.cacheRegionDefinitions != null) {
            for (CacheRegionDefinition localCacheRegionDefinition : mergedSettings.cacheRegionDefinitions) {
                metamodelBuilder.applyCacheRegionDefinition(localCacheRegionDefinition);
            }
        }
        if ((typeContributorList = (TypeContributorList)this.configurationValues.remove(TYPE_CONTRIBUTORS)) != null) {
            for (TypeContributor typeContributor : typeContributorList.getTypeContributors()) {
                metamodelBuilder.applyTypes(typeContributor);
            }
        }
        if (attributeConverterDefinitions != null) {
            for (AttributeConverterDefinition attributeConverterDefinition : attributeConverterDefinitions) {
                metamodelBuilder.applyAttributeConverter(attributeConverterDefinition);
            }
        }
    }

    public MetadataImplementor getMetadata() {
        return this.metadata;
    }

    @Override
    public EntityManagerFactoryBuilder withValidatorFactory(Object validatorFactory) {
        this.validatorFactory = validatorFactory;
        if (validatorFactory != null) {
            BeanValidationIntegrator.validateFactory(validatorFactory);
        }
        return this;
    }

    @Override
    public EntityManagerFactoryBuilder withDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    @Override
    public void cancel() {
    }

    private MetadataImplementor metadata() {
        if (this.metadata == null) {
            this.metadata = MetadataBuildingProcess.complete(this.managedResources, this.metamodelBuilder.getMetadataBuildingOptions());
        }
        return this.metadata;
    }

    @Override
    public void generateSchema() {
        try {
            SessionFactoryBuilder sfBuilder = this.metadata().getSessionFactoryBuilder();
            this.populate(sfBuilder, this.standardServiceRegistry);
            SchemaManagementToolCoordinator.process(this.metadata, this.standardServiceRegistry, this.configurationValues, DelayedDropRegistryNotAvailableImpl.INSTANCE);
        }
        catch (Exception e) {
            throw this.persistenceException("Error performing schema management", e);
        }
        this.cancel();
    }

    @Override
    public EntityManagerFactory build() {
        SessionFactoryBuilder sfBuilder = this.metadata().getSessionFactoryBuilder();
        this.populate(sfBuilder, this.standardServiceRegistry);
        try {
            return sfBuilder.build();
        }
        catch (Exception e) {
            throw this.persistenceException("Unable to build Hibernate SessionFactory", e);
        }
    }

    protected void populate(SessionFactoryBuilder sfBuilder, StandardServiceRegistry ssr) {
        Object sessionFactoryObserverSetting;
        boolean allowRefreshDetachedEntity;
        ((SessionFactoryBuilderImplementor)sfBuilder).markAsJpaBootstrap();
        StrategySelector strategySelector = ssr.getService(StrategySelector.class);
        boolean jtaTransactionAccessEnabled = this.readBooleanConfigurationValue("hibernate.jta.allowTransactionAccess");
        if (!jtaTransactionAccessEnabled) {
            ((SessionFactoryBuilderImplementor)sfBuilder).disableJtaTransactionAccess();
        }
        if (!(allowRefreshDetachedEntity = this.readBooleanConfigurationValue("hibernate.allow_refresh_detached_entity"))) {
            ((SessionFactoryBuilderImplementor)sfBuilder).disableRefreshDetachedEntity();
        }
        if ((sessionFactoryObserverSetting = this.configurationValues.remove("hibernate.ejb.session_factory_observer")) != null) {
            SessionFactoryObserver suppliedSessionFactoryObserver = strategySelector.resolveStrategy(SessionFactoryObserver.class, sessionFactoryObserverSetting);
            sfBuilder.addSessionFactoryObservers(suppliedSessionFactoryObserver);
        }
        sfBuilder.addSessionFactoryObservers(ServiceRegistryCloser.INSTANCE);
        sfBuilder.applyEntityNotFoundDelegate(JpaEntityNotFoundDelegate.INSTANCE);
        if (this.validatorFactory != null) {
            sfBuilder.applyValidatorFactory(this.validatorFactory);
        }
        if (this.cdiBeanManager != null) {
            sfBuilder.applyBeanManager(this.cdiBeanManager);
        }
    }

    private PersistenceException persistenceException(String message) {
        return this.persistenceException(message, null);
    }

    private PersistenceException persistenceException(String message, Exception cause) {
        return new PersistenceException(this.getExceptionHeader() + message, (Throwable)cause);
    }

    private String getExceptionHeader() {
        return "[PersistenceUnit: " + this.persistenceUnit.getName() + "] ";
    }

    private static class MergedSettings {
        private final Map configurationValues = new ConcurrentHashMap(16, 0.75f, 1);
        private Map<String, JaccPermissionDeclarations> jaccPermissionsByContextId;
        private List<CacheRegionDefinition> cacheRegionDefinitions;

        private MergedSettings() {
        }

        public Map getConfigurationValues() {
            return this.configurationValues;
        }

        private JaccPermissionDeclarations getJaccPermissions(String jaccContextId) {
            JaccPermissionDeclarations jaccPermissions;
            if (this.jaccPermissionsByContextId == null) {
                this.jaccPermissionsByContextId = new HashMap<String, JaccPermissionDeclarations>();
            }
            if ((jaccPermissions = this.jaccPermissionsByContextId.get(jaccContextId)) == null) {
                jaccPermissions = new JaccPermissionDeclarations(jaccContextId);
                this.jaccPermissionsByContextId.put(jaccContextId, jaccPermissions);
            }
            return jaccPermissions;
        }

        private void addCacheRegionDefinition(CacheRegionDefinition cacheRegionDefinition) {
            if (this.cacheRegionDefinitions == null) {
                this.cacheRegionDefinitions = new ArrayList<CacheRegionDefinition>();
            }
            this.cacheRegionDefinitions.add(cacheRegionDefinition);
        }
    }

    private static class ServiceRegistryCloser
    implements SessionFactoryObserver {
        public static final ServiceRegistryCloser INSTANCE = new ServiceRegistryCloser();

        private ServiceRegistryCloser() {
        }

        @Override
        public void sessionFactoryCreated(SessionFactory sessionFactory) {
        }

        @Override
        public void sessionFactoryClosed(SessionFactory sessionFactory) {
            SessionFactoryImplementor sfi = (SessionFactoryImplementor)sessionFactory;
            sfi.getServiceRegistry().destroy();
            ServiceRegistry basicRegistry = sfi.getServiceRegistry().getParentServiceRegistry();
            ((ServiceRegistryImplementor)basicRegistry).destroy();
        }
    }

    private static class JpaEntityNotFoundDelegate
    implements EntityNotFoundDelegate,
    Serializable {
        public static final JpaEntityNotFoundDelegate INSTANCE = new JpaEntityNotFoundDelegate();

        private JpaEntityNotFoundDelegate() {
        }

        @Override
        public void handleEntityNotFound(String entityName, Serializable id) {
            throw new EntityNotFoundException("Unable to find " + entityName + " with id " + id);
        }
    }
}

