/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.cache.internal.NoCachingRegionFactory;
import org.hibernate.cache.internal.StrategyCreatorRegionFactoryImpl;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class RegionFactoryInitiator
implements StandardServiceInitiator<RegionFactory> {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(RegionFactoryInitiator.class);
    public static final RegionFactoryInitiator INSTANCE = new RegionFactoryInitiator();

    @Override
    public Class<RegionFactory> getServiceInitiated() {
        return RegionFactory.class;
    }

    @Override
    public RegionFactory initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        Properties p = new Properties();
        if (configurationValues != null) {
            p.putAll((Map<?, ?>)configurationValues);
        }
        boolean useSecondLevelCache = ConfigurationHelper.getBoolean("hibernate.cache.use_second_level_cache", configurationValues, true);
        boolean useQueryCache = ConfigurationHelper.getBoolean("hibernate.cache.use_query_cache", configurationValues);
        RegionFactory regionFactory = NoCachingRegionFactory.INSTANCE;
        if (useSecondLevelCache || useQueryCache) {
            Object setting = configurationValues != null ? configurationValues.get("hibernate.cache.region.factory_class") : null;
            regionFactory = registry.getService(StrategySelector.class).resolveStrategy(RegionFactory.class, setting, NoCachingRegionFactory.INSTANCE, new StrategyCreatorRegionFactoryImpl(p));
        }
        LOG.debugf("Cache region factory : %s", regionFactory.getClass().getName());
        return regionFactory;
    }

    public static String mapLegacyNames(String name) {
        if ("org.hibernate.cache.EhCacheRegionFactory".equals(name)) {
            return "org.hibernate.cache.ehcache.EhCacheRegionFactory";
        }
        if ("org.hibernate.cache.SingletonEhCacheRegionFactory".equals(name)) {
            return "org.hibernate.cache.ehcache.SingletonEhCacheRegionFactory";
        }
        return name;
    }
}

