/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Parameter;
import org.hibernate.QueryParameterException;
import org.hibernate.engine.query.spi.NamedParameterDescriptor;
import org.hibernate.engine.query.spi.OrdinalParameterDescriptor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.query.ParameterMetadata;
import org.hibernate.query.QueryParameter;
import org.hibernate.type.Type;

public class ParameterMetadataImpl
implements ParameterMetadata {
    private static final OrdinalParameterDescriptor[] EMPTY_ORDINALS = new OrdinalParameterDescriptor[0];
    private final OrdinalParameterDescriptor[] ordinalDescriptors;
    private final Map<String, NamedParameterDescriptor> namedDescriptorMap;
    private boolean isOrdinalParametersZeroBased = true;

    private ParameterMetadataImpl(OrdinalParameterDescriptor[] ordinalDescriptors, Map<String, NamedParameterDescriptor> namedDescriptorMap, boolean isOrdinalParametersZeroBased) {
        this.ordinalDescriptors = ordinalDescriptors;
        this.namedDescriptorMap = namedDescriptorMap;
        this.isOrdinalParametersZeroBased = isOrdinalParametersZeroBased;
    }

    public ParameterMetadataImpl(OrdinalParameterDescriptor[] ordinalDescriptors, Map<String, NamedParameterDescriptor> namedDescriptorMap) {
        if (ordinalDescriptors == null) {
            this.ordinalDescriptors = EMPTY_ORDINALS;
        } else {
            OrdinalParameterDescriptor[] copy = new OrdinalParameterDescriptor[ordinalDescriptors.length];
            System.arraycopy(ordinalDescriptors, 0, copy, 0, ordinalDescriptors.length);
            this.ordinalDescriptors = copy;
        }
        if (namedDescriptorMap == null) {
            this.namedDescriptorMap = Collections.emptyMap();
        } else {
            int size = (int)((double)namedDescriptorMap.size() / 0.75 + 1.0);
            HashMap<String, NamedParameterDescriptor> copy = new HashMap<String, NamedParameterDescriptor>(size);
            copy.putAll(namedDescriptorMap);
            this.namedDescriptorMap = Collections.unmodifiableMap(copy);
        }
    }

    @Override
    public Set<QueryParameter<?>> collectAllParameters() {
        if (this.hasNamedParameters() || this.hasPositionalParameters()) {
            HashSet allParameters = new HashSet();
            allParameters.addAll(this.namedDescriptorMap.values());
            allParameters.addAll(ArrayHelper.toList(this.ordinalDescriptors));
            return allParameters;
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Parameter<?>> collectAllParametersJpa() {
        if (this.hasNamedParameters() || this.hasPositionalParameters()) {
            HashSet allParameters = new HashSet();
            allParameters.addAll(this.namedDescriptorMap.values());
            allParameters.addAll(ArrayHelper.toList(this.ordinalDescriptors));
            return allParameters;
        }
        return Collections.emptySet();
    }

    @Override
    public boolean hasNamedParameters() {
        return !this.namedDescriptorMap.isEmpty();
    }

    @Override
    public boolean hasPositionalParameters() {
        return this.getOrdinalParameterCount() > 0;
    }

    @Override
    public int getPositionalParameterCount() {
        return this.getOrdinalParameterCount();
    }

    public int getOrdinalParameterCount() {
        return this.ordinalDescriptors.length;
    }

    public OrdinalParameterDescriptor getOrdinalParameterDescriptor(int position) {
        if (!this.isOrdinalParametersZeroBased) {
            --position;
        }
        if (position < 0 || position >= this.ordinalDescriptors.length) {
            throw new QueryParameterException("Position beyond number of declared ordinal parameters. Remember that ordinal parameters are 0-based! Position: " + position);
        }
        return this.ordinalDescriptors[position];
    }

    @Deprecated
    public Type getOrdinalParameterExpectedType(int position) {
        return this.getOrdinalParameterDescriptor(position).getExpectedType();
    }

    @Deprecated
    public int getOrdinalParameterSourceLocation(int position) {
        return this.getOrdinalParameterDescriptor(position).getSourceLocation();
    }

    @Override
    public Set<String> getNamedParameterNames() {
        return this.namedDescriptorMap.keySet();
    }

    @Override
    public <T> QueryParameter<T> getQueryParameter(String name) {
        return this.getNamedParameterDescriptor(name);
    }

    @Override
    public <T> QueryParameter<T> getQueryParameter(Integer position) {
        return this.getOrdinalParameterDescriptor(position);
    }

    @Override
    public <T> QueryParameter<T> resolve(Parameter<T> param) {
        if (param instanceof QueryParameter) {
            return (QueryParameter)param;
        }
        if (param.getName() != null) {
            return this.getQueryParameter(param.getName());
        }
        if (param.getPosition() != null) {
            return this.getQueryParameter(param.getPosition());
        }
        throw new IllegalArgumentException("Could not resolve javax.persistence.Parameter to org.hibernate.query.QueryParameter");
    }

    public NamedParameterDescriptor getNamedParameterDescriptor(String name) {
        NamedParameterDescriptor meta = this.namedDescriptorMap.get(name);
        if (meta == null) {
            throw new QueryParameterException("could not locate named parameter [" + name + "]");
        }
        return meta;
    }

    @Deprecated
    public Type getNamedParameterExpectedType(String name) {
        return this.getNamedParameterDescriptor(name).getExpectedType();
    }

    @Deprecated
    public int[] getNamedParameterSourceLocations(String name) {
        return this.getNamedParameterDescriptor(name).getSourceLocations();
    }

    @Override
    public boolean isOrdinalParametersZeroBased() {
        return this.isOrdinalParametersZeroBased;
    }

    @Override
    public void setOrdinalParametersZeroBased(boolean isZeroBased) {
        this.isOrdinalParametersZeroBased = isZeroBased;
    }

    public ParameterMetadataImpl getOrdinalParametersZeroBasedCopy() {
        return new ParameterMetadataImpl(this.ordinalDescriptors, this.namedDescriptorMap, true);
    }
}

