/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.internal.regions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.constructs.nonstop.NonStopCacheException;
import net.sf.ehcache.util.Timestamper;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.ehcache.EhCacheMessageLogger;
import org.hibernate.cache.ehcache.internal.nonstop.HibernateNonstopCacheExceptionHandler;
import org.hibernate.cache.ehcache.internal.strategy.EhcacheAccessStrategyFactory;
import org.hibernate.cache.spi.Region;
import org.jboss.logging.Logger;

public abstract class EhcacheDataRegion
implements Region {
    private static final EhCacheMessageLogger LOG = (EhCacheMessageLogger)Logger.getMessageLogger(EhCacheMessageLogger.class, (String)EhcacheDataRegion.class.getName());
    private static final String CACHE_LOCK_TIMEOUT_PROPERTY = "net.sf.ehcache.hibernate.cache_lock_timeout";
    private static final int DEFAULT_CACHE_LOCK_TIMEOUT = 60000;
    private final Ehcache cache;
    private final EhcacheAccessStrategyFactory accessStrategyFactory;
    private final int cacheLockTimeout;

    EhcacheDataRegion(EhcacheAccessStrategyFactory accessStrategyFactory, Ehcache cache, Properties properties) {
        this.accessStrategyFactory = accessStrategyFactory;
        this.cache = cache;
        String timeout = properties.getProperty(CACHE_LOCK_TIMEOUT_PROPERTY, Integer.toString(60000));
        this.cacheLockTimeout = Timestamper.ONE_MS * Integer.decode(timeout);
    }

    protected Ehcache getCache() {
        return this.cache;
    }

    protected EhcacheAccessStrategyFactory getAccessStrategyFactory() {
        return this.accessStrategyFactory;
    }

    public Ehcache getEhcache() {
        return this.getCache();
    }

    public String getName() {
        return this.getCache().getName();
    }

    public void destroy() throws CacheException {
        try {
            this.getCache().getCacheManager().removeCache(this.getCache().getName());
        }
        catch (IllegalStateException e) {
            LOG.debug("This can happen if multiple frameworks both try to shutdown ehcache", e);
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)e);
            }
            throw new CacheException((Throwable)e);
        }
    }

    public long getSizeInMemory() {
        try {
            return this.getCache().calculateInMemorySize();
        }
        catch (Throwable t) {
            if (t instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)t);
            }
            return -1L;
        }
    }

    public long getElementCountInMemory() {
        try {
            return this.getCache().getMemoryStoreSize();
        }
        catch (net.sf.ehcache.CacheException ce) {
            if (ce instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)ce);
                return -1L;
            }
            throw new CacheException((Throwable)ce);
        }
    }

    public long getElementCountOnDisk() {
        try {
            return this.getCache().getDiskStoreSize();
        }
        catch (net.sf.ehcache.CacheException ce) {
            if (ce instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)ce);
                return -1L;
            }
            throw new CacheException((Throwable)ce);
        }
    }

    public Map toMap() {
        try {
            HashMap result = new HashMap();
            for (Object key : this.getCache().getKeys()) {
                result.put(key, this.getCache().get(key).getObjectValue());
            }
            return result;
        }
        catch (Exception e) {
            if (e instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)e);
                return Collections.emptyMap();
            }
            throw new CacheException((Throwable)e);
        }
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public int getTimeout() {
        return this.cacheLockTimeout;
    }

    public boolean contains(Object key) {
        return this.getCache().isKeyInCache(key);
    }
}

