/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.DOMWriter;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.cfg.Configuration;
import org.hibernate.envers.configuration.internal.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.internal.ClassesAuditingData;
import org.hibernate.envers.configuration.internal.GlobalConfiguration;
import org.hibernate.envers.configuration.internal.PersistentClassGraphDefiner;
import org.hibernate.envers.configuration.internal.metadata.AuditEntityNameRegister;
import org.hibernate.envers.configuration.internal.metadata.AuditMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.EntityXmlMappingData;
import org.hibernate.envers.configuration.internal.metadata.reader.AnnotationsMetadataReader;
import org.hibernate.envers.configuration.internal.metadata.reader.ClassAuditingData;
import org.hibernate.envers.internal.entities.EntitiesConfigurations;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.envers.internal.tools.graph.GraphTopologicalSort;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.mapping.PersistentClass;

public class EntitiesConfigurator {
    public EntitiesConfigurations configure(Configuration cfg, ReflectionManager reflectionManager, GlobalConfiguration globalCfg, AuditEntitiesConfiguration verEntCfg, AuditStrategy auditStrategy, ClassLoaderService classLoaderService, Document revisionInfoXmlMapping, Element revisionInfoRelationMapping) {
        AuditEntityNameRegister auditEntityNameRegister = new AuditEntityNameRegister();
        DOMWriter writer = new DOMWriter();
        Iterator<PersistentClass> classes = GraphTopologicalSort.sort(new PersistentClassGraphDefiner(cfg)).iterator();
        ClassesAuditingData classesAuditingData = new ClassesAuditingData();
        HashMap<PersistentClass, EntityXmlMappingData> xmlMappings = new HashMap<PersistentClass, EntityXmlMappingData>();
        while (classes.hasNext()) {
            PersistentClass pc = classes.next();
            if (pc.getClassName() == null) continue;
            AnnotationsMetadataReader annotationsMetadataReader = new AnnotationsMetadataReader(globalCfg, reflectionManager, pc);
            ClassAuditingData auditData = annotationsMetadataReader.getAuditData();
            classesAuditingData.addClassAuditingData(pc, auditData);
        }
        classesAuditingData.updateCalculatedFields();
        AuditMetadataGenerator auditMetaGen = new AuditMetadataGenerator(cfg, globalCfg, verEntCfg, auditStrategy, classLoaderService, revisionInfoRelationMapping, auditEntityNameRegister);
        for (Map.Entry<PersistentClass, ClassAuditingData> pcDatasEntry : classesAuditingData.getAllClassAuditedData()) {
            PersistentClass pc = pcDatasEntry.getKey();
            ClassAuditingData auditData = pcDatasEntry.getValue();
            EntityXmlMappingData xmlMappingData = new EntityXmlMappingData();
            if (auditData.isAudited()) {
                if (!StringTools.isEmpty(auditData.getAuditTable().value())) {
                    verEntCfg.addCustomAuditTableName(pc.getEntityName(), auditData.getAuditTable().value());
                }
                auditMetaGen.generateFirstPass(pc, auditData, xmlMappingData, true);
            } else {
                auditMetaGen.generateFirstPass(pc, auditData, xmlMappingData, false);
            }
            xmlMappings.put(pc, xmlMappingData);
        }
        for (Map.Entry<PersistentClass, ClassAuditingData> pcDatasEntry : classesAuditingData.getAllClassAuditedData()) {
            EntityXmlMappingData xmlMappingData = (EntityXmlMappingData)xmlMappings.get(pcDatasEntry.getKey());
            if (!pcDatasEntry.getValue().isAudited()) continue;
            auditMetaGen.generateSecondPass(pcDatasEntry.getKey(), pcDatasEntry.getValue(), xmlMappingData);
            try {
                cfg.addDocument(writer.write(xmlMappingData.getMainXmlMapping()));
                for (Document additionalMapping : xmlMappingData.getAdditionalXmlMappings()) {
                    cfg.addDocument(writer.write(additionalMapping));
                }
            }
            catch (DocumentException e) {
                throw new MappingException((Throwable)e);
            }
        }
        if (auditMetaGen.getEntitiesConfigurations().size() > 0) {
            try {
                if (revisionInfoXmlMapping != null) {
                    cfg.addDocument(writer.write(revisionInfoXmlMapping));
                }
            }
            catch (DocumentException e) {
                throw new MappingException((Throwable)e);
            }
        }
        return new EntitiesConfigurations(auditMetaGen.getEntitiesConfigurations(), auditMetaGen.getNotAuditedEntitiesConfigurations());
    }

    private void writeDocument(Document e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter w = new PrintWriter(baos);
        try {
            XMLWriter xw = new XMLWriter((Writer)w, new OutputFormat(" ", true));
            xw.write(e);
            ((Writer)w).flush();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        System.out.println("-----------");
        System.out.println(baos.toString());
        System.out.println("-----------");
    }
}

