/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.builtin.time.impl;

import java.lang.invoke.MethodHandles;
import java.time.DateTimeException;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchTemporalAccessorStringBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchYearBridge;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchYearMonthBridge
extends ElasticsearchTemporalAccessorStringBridge<YearMonth> {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(ElasticsearchYearBridge.FORMATTER).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);
    public static final ElasticsearchYearMonthBridge INSTANCE = new ElasticsearchYearMonthBridge();

    private ElasticsearchYearMonthBridge() {
        super(FORMATTER, YearMonth.class);
    }

    @Override
    YearMonth parse(DateTimeFormatter formatter, String stringValue) throws DateTimeException {
        return YearMonth.parse(stringValue, formatter);
    }

    @Override
    protected IllegalArgumentException createInvalidIndexNullAsException(String indexNullAs, DateTimeException e) {
        return LOG.invalidNullMarkerForYearMonth(e);
    }
}

