/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.impl;

import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import org.apache.lucene.util.Version;
import org.hibernate.search.analyzer.impl.LuceneEmbeddedAnalyzerStrategy;
import org.hibernate.search.analyzer.spi.AnalyzerStrategy;
import org.hibernate.search.cfg.Environment;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.nulls.impl.LuceneMissingValueStrategy;
import org.hibernate.search.engine.nulls.impl.MissingValueStrategy;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.LuceneEmbeddedIndexFamily;
import org.hibernate.search.indexes.spi.IndexFamilyImplementor;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LuceneEmbeddedIndexFamilyImpl
implements IndexFamilyImplementor,
LuceneEmbeddedIndexFamily {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final ServiceManager serviceManager;
    private final String defaultAnalyzer;
    private final Version luceneMatchVersion;

    public LuceneEmbeddedIndexFamilyImpl(ServiceManager serviceManager, SearchConfiguration cfg) {
        this.serviceManager = serviceManager;
        this.defaultAnalyzer = cfg.getProperty("hibernate.search.analyzer");
        this.luceneMatchVersion = this.getLuceneMatchVersion(cfg);
    }

    @Override
    public void close() {
    }

    @Override
    public <T> T unwrap(Class<T> unwrappedClass) {
        if (unwrappedClass.isAssignableFrom(LuceneEmbeddedIndexFamily.class)) {
            return (T)this;
        }
        throw new SearchException("Cannot unwrap a '" + this.getClass().getName() + "' into a '" + unwrappedClass.getName() + "'");
    }

    @Override
    public AnalyzerStrategy createAnalyzerStrategy() {
        return new LuceneEmbeddedAnalyzerStrategy(this.serviceManager, this.defaultAnalyzer, this.luceneMatchVersion);
    }

    @Override
    public MissingValueStrategy getMissingValueStrategy() {
        return LuceneMissingValueStrategy.INSTANCE;
    }

    private Version getLuceneMatchVersion(SearchConfiguration cfg) {
        Version version;
        String tmp = cfg.getProperty("hibernate.search.lucene_version");
        if (StringHelper.isEmpty(tmp)) {
            log.recommendConfiguringLuceneVersion();
            version = Environment.DEFAULT_LUCENE_MATCH_VERSION;
        } else {
            try {
                version = Version.parseLeniently((String)tmp);
                if (log.isDebugEnabled()) {
                    log.debug("Setting Lucene compatibility to Version " + version);
                }
            }
            catch (IllegalArgumentException e) {
                throw log.illegalLuceneVersionFormat(tmp, e.getMessage());
            }
            catch (ParseException e) {
                throw log.illegalLuceneVersionFormat(tmp, e.getMessage());
            }
        }
        return version;
    }
}

