/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class InternalAnalyzerUtils {
    private static final Log log = LoggerFactory.make();

    private InternalAnalyzerUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String analyzeSortableValue(Analyzer analyzer, String fieldName, String text) {
        String string;
        TokenStream stream = analyzer.tokenStream(fieldName, (Reader)new StringReader(text));
        try {
            String firstToken = null;
            CharTermAttribute term = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
            stream.reset();
            if (stream.incrementToken()) {
                firstToken = new String(term.buffer(), 0, term.length());
                if (stream.incrementToken()) {
                    log.multipleTermsInAnalyzedSortableField(fieldName);
                } else {
                    stream.end();
                }
            }
            string = firstToken;
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException | SearchException e) {
                throw log.couldNotAnalyzeSortableField(fieldName, e);
            }
        }
        stream.close();
        return string;
    }
}

