/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend;

import java.io.Serializable;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.backend.LuceneWork;

public class UpdateLuceneWork
extends LuceneWork {
    private static final long serialVersionUID = -5267394465359187688L;
    private final Map<String, String> fieldToAnalyzerMap;

    public UpdateLuceneWork(Serializable id, String idInString, Class<?> entity, Document document) {
        this(null, id, idInString, entity, document, null);
    }

    public UpdateLuceneWork(String tenantId, Serializable id, String idInString, Class<?> entity, Document document) {
        this(tenantId, id, idInString, entity, document, null);
    }

    public UpdateLuceneWork(Serializable id, String idInString, Class<?> entity, Document document, Map<String, String> fieldToAnalyzerMap) {
        this(null, id, idInString, entity, document);
    }

    public UpdateLuceneWork(String tenantId, Serializable id, String idInString, Class<?> entity, Document document, Map<String, String> fieldToAnalyzerMap) {
        super(tenantId, id, idInString, entity, document);
        this.fieldToAnalyzerMap = fieldToAnalyzerMap;
    }

    @Override
    public Map<String, String> getFieldToAnalyzerMap() {
        return this.fieldToAnalyzerMap;
    }

    @Override
    public <P, R> R acceptIndexWorkVisitor(IndexWorkVisitor<P, R> visitor, P p) {
        return visitor.visitUpdateWork(this, p);
    }

    public String toString() {
        String tenant = this.getTenantId() == null ? "" : " [" + this.getTenantId() + "] ";
        return "UpdateLuceneWork" + tenant + ": " + this.getEntityClass().getName() + "#" + this.getIdInString();
    }
}

