/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.impl;

import java.lang.reflect.AnnotatedElement;
import java.util.Calendar;
import org.hibernate.search.annotations.CalendarBridge;
import org.hibernate.search.annotations.EncodingType;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.NumericEncodingCalendarBridge;
import org.hibernate.search.bridge.builtin.StringEncodingCalendarBridge;
import org.hibernate.search.bridge.impl.ExtendedBridgeProvider;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class CalendarBridgeProvider
extends ExtendedBridgeProvider {
    private static final Log LOG = LoggerFactory.make();

    CalendarBridgeProvider() {
    }

    @Override
    public FieldBridge provideFieldBridge(ExtendedBridgeProvider.ExtendedBridgeProviderContext context) {
        AnnotatedElement annotatedElement = context.getAnnotatedElement();
        if (Calendar.class.isAssignableFrom(context.getReturnType())) {
            if (annotatedElement.isAnnotationPresent(CalendarBridge.class)) {
                CalendarBridge dateBridgeAnnotation = annotatedElement.getAnnotation(CalendarBridge.class);
                Resolution resolution = dateBridgeAnnotation.resolution();
                EncodingType encodingType = dateBridgeAnnotation.encoding();
                return this.getDateFieldBridge(resolution, encodingType);
            }
            return this.getDateFieldBridge(Resolution.MILLISECOND, EncodingType.NUMERIC);
        }
        return null;
    }

    private FieldBridge getDateFieldBridge(Resolution resolution, EncodingType encodingType) {
        switch (encodingType) {
            case NUMERIC: {
                switch (resolution) {
                    case YEAR: {
                        return NumericEncodingCalendarBridge.DATE_YEAR;
                    }
                    case MONTH: {
                        return NumericEncodingCalendarBridge.DATE_MONTH;
                    }
                    case DAY: {
                        return NumericEncodingCalendarBridge.DATE_DAY;
                    }
                    case HOUR: {
                        return NumericEncodingCalendarBridge.DATE_HOUR;
                    }
                    case MINUTE: {
                        return NumericEncodingCalendarBridge.DATE_MINUTE;
                    }
                    case SECOND: {
                        return NumericEncodingCalendarBridge.DATE_SECOND;
                    }
                    case MILLISECOND: {
                        return NumericEncodingCalendarBridge.DATE_MILLISECOND;
                    }
                }
                throw LOG.unknownResolution(resolution.toString());
            }
            case STRING: {
                switch (resolution) {
                    case YEAR: {
                        return StringEncodingCalendarBridge.DATE_YEAR;
                    }
                    case MONTH: {
                        return StringEncodingCalendarBridge.DATE_MONTH;
                    }
                    case DAY: {
                        return StringEncodingCalendarBridge.DATE_DAY;
                    }
                    case HOUR: {
                        return StringEncodingCalendarBridge.DATE_HOUR;
                    }
                    case MINUTE: {
                        return StringEncodingCalendarBridge.DATE_MINUTE;
                    }
                    case SECOND: {
                        return StringEncodingCalendarBridge.DATE_SECOND;
                    }
                    case MILLISECOND: {
                        return StringEncodingCalendarBridge.DATE_MILLISECOND;
                    }
                }
                throw LOG.unknownResolution(resolution.toString());
            }
        }
        throw LOG.unknownEncodingType(encodingType.name());
    }
}

