/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.apache.lucene.search.Filter;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.query.dsl.WildcardContext;
import org.hibernate.search.query.dsl.impl.ConnectedTermMatchingContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.TermQueryContext;

class ConnectedWildcardContext
implements WildcardContext {
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final TermQueryContext termContext;

    public ConnectedWildcardContext(QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.termContext = new TermQueryContext(TermQueryContext.Approximation.WILDCARD);
    }

    @Override
    public TermMatchingContext onField(String field) {
        return new ConnectedTermMatchingContext(this.termContext, field, this.queryCustomizer, this.queryContext);
    }

    @Override
    public TermMatchingContext onFields(String ... fields) {
        return new ConnectedTermMatchingContext(this.termContext, fields, this.queryCustomizer, this.queryContext);
    }

    @Override
    public WildcardContext boostedTo(float boost) {
        this.queryCustomizer.boostedTo(boost);
        return this;
    }

    @Override
    public WildcardContext withConstantScore() {
        this.queryCustomizer.withConstantScore();
        return this;
    }

    @Override
    public WildcardContext filteredBy(Filter filter) {
        this.queryCustomizer.filteredBy(filter);
        return this;
    }
}

