/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.engine.impl.DocumentBuilderHelper;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.engine.impl.EntityInfoImpl;
import org.hibernate.search.query.engine.impl.LazyQueryState;
import org.hibernate.search.query.engine.impl.QueryHits;
import org.hibernate.search.query.engine.impl.ReusableDocumentStoredFieldVisitor;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.EntityInfo;

public class DocumentExtractorImpl
implements DocumentExtractor {
    private final ExtendedSearchIntegrator extendedIntegrator;
    private final String[] projection;
    private final QueryHits queryHits;
    private final LazyQueryState searcher;
    private ReusableDocumentStoredFieldVisitor fieldLoadingVisitor;
    private boolean allowFieldSelection;
    private boolean needId;
    private boolean hasProjectionConstants;
    private final Map<String, Class> targetedClasses;
    private final int firstIndex;
    private final int maxIndex;
    private final Class singleClassIfPossible;
    private final ConversionContext exceptionWrap = new ContextualExceptionBridgeHelper();

    public DocumentExtractorImpl(QueryHits queryHits, ExtendedSearchIntegrator extendedIntegrator, String[] projection, Set<String> idFieldNames, boolean allowFieldSelection, LazyQueryState searcher, int firstIndex, int maxIndex, Set<Class<?>> classesAndSubclasses) {
        this.extendedIntegrator = extendedIntegrator;
        this.projection = projection != null ? (String[])projection.clone() : null;
        this.queryHits = queryHits;
        this.allowFieldSelection = allowFieldSelection;
        if (classesAndSubclasses.size() == 1) {
            this.singleClassIfPossible = classesAndSubclasses.iterator().next();
            this.targetedClasses = null;
        } else {
            this.singleClassIfPossible = null;
            this.targetedClasses = new HashMap<String, Class>(classesAndSubclasses.size());
            for (Class<?> clazz : classesAndSubclasses) {
                this.targetedClasses.put(clazz.getName(), clazz);
            }
        }
        this.searcher = searcher;
        this.firstIndex = firstIndex;
        this.maxIndex = maxIndex;
        this.initFieldSelection(projection, idFieldNames);
    }

    private void initFieldSelection(String[] projection, Set<String> idFieldNames) {
        HashSet<String> fields;
        if (projection == null) {
            this.needId = true;
            fields = new HashSet<String>(2);
        } else {
            fields = new HashSet(projection.length + 2);
            for (String projectionName : projection) {
                if (projectionName == null) continue;
                if ("__HSearch_This".equals(projectionName)) {
                    this.needId = true;
                    this.hasProjectionConstants = true;
                    continue;
                }
                if ("__HSearch_Document".equals(projectionName)) {
                    this.allowFieldSelection = false;
                    this.needId = true;
                    this.hasProjectionConstants = true;
                    return;
                }
                if ("__HSearch_Score".equals(projectionName)) {
                    this.hasProjectionConstants = true;
                    continue;
                }
                if ("__HSearch_id".equals(projectionName)) {
                    this.needId = true;
                    this.hasProjectionConstants = true;
                    continue;
                }
                if ("__HSearch_DocumentId".equals(projectionName)) {
                    this.hasProjectionConstants = true;
                    continue;
                }
                if ("__HSearch_Explanation".equals(projectionName)) {
                    this.hasProjectionConstants = true;
                    continue;
                }
                if ("_hibernate_class".equals(projectionName)) {
                    this.hasProjectionConstants = true;
                    continue;
                }
                if ("_HSearch_SpatialDistance".equals(projectionName)) {
                    this.hasProjectionConstants = true;
                    continue;
                }
                fields.add(projectionName);
            }
        }
        if (this.singleClassIfPossible == null) {
            fields.add("_hibernate_class");
        }
        if (this.needId) {
            for (String idFieldName : idFieldNames) {
                fields.add(idFieldName);
            }
        }
        if (fields.size() != 0) {
            this.fieldLoadingVisitor = new ReusableDocumentStoredFieldVisitor(fields);
        }
    }

    private Serializable extractId(Document document, Class clazz) {
        if (!this.needId) {
            return null;
        }
        return DocumentBuilderHelper.getDocumentId(this.extendedIntegrator, clazz, document, this.exceptionWrap);
    }

    private Class extractClass(Document document) throws IOException {
        if (this.singleClassIfPossible != null) {
            return this.singleClassIfPossible;
        }
        String className = document.get("_hibernate_class");
        Class clazz = this.targetedClasses.get(className);
        if (clazz != null) {
            return clazz;
        }
        return DocumentBuilderHelper.getDocumentClass(className, this.extendedIntegrator.getServiceManager());
    }

    @Override
    public EntityInfo extract(int scoreDocIndex) throws IOException {
        int docId = this.queryHits.docId(scoreDocIndex);
        Document document = this.extractDocument(scoreDocIndex);
        Class clazz = this.extractClass(document);
        String idName = DocumentBuilderHelper.getDocumentIdName(this.extendedIntegrator, clazz);
        Serializable id = this.extractId(document, clazz);
        Object[] projected = null;
        if (this.projection != null && this.projection.length > 0) {
            projected = DocumentBuilderHelper.getDocumentFields(this.extendedIntegrator, clazz, document, this.projection, this.exceptionWrap);
            if (this.hasProjectionConstants) {
                for (int x = 0; x < this.projection.length; ++x) {
                    if ("__HSearch_Score".equals(this.projection[x])) {
                        projected[x] = Float.valueOf(this.queryHits.score(scoreDocIndex));
                        continue;
                    }
                    if ("__HSearch_id".equals(this.projection[x])) {
                        projected[x] = id;
                        continue;
                    }
                    if ("__HSearch_Document".equals(this.projection[x])) {
                        projected[x] = document;
                        continue;
                    }
                    if ("__HSearch_DocumentId".equals(this.projection[x])) {
                        projected[x] = docId;
                        continue;
                    }
                    if ("__HSearch_Explanation".equals(this.projection[x])) {
                        projected[x] = this.queryHits.explain(scoreDocIndex);
                        continue;
                    }
                    if ("_hibernate_class".equals(this.projection[x])) {
                        projected[x] = clazz;
                        continue;
                    }
                    if ("_HSearch_SpatialDistance".equals(this.projection[x])) {
                        projected[x] = this.queryHits.spatialDistance(scoreDocIndex);
                        continue;
                    }
                    if (!"__HSearch_This".equals(this.projection[x])) continue;
                    projected[x] = EntityInfo.ENTITY_PLACEHOLDER;
                }
            }
        }
        return new EntityInfoImpl(clazz, idName, id, projected);
    }

    @Override
    public int getFirstIndex() {
        return this.firstIndex;
    }

    @Override
    public int getMaxIndex() {
        return this.maxIndex;
    }

    @Override
    public void close() {
        this.searcher.close();
    }

    private Document extractDocument(int index) throws IOException {
        if (this.allowFieldSelection) {
            if (this.fieldLoadingVisitor == null) {
                return null;
            }
            this.queryHits.visitDocument(index, this.fieldLoadingVisitor);
            return this.fieldLoadingVisitor.getDocumentAndReset();
        }
        return this.queryHits.doc(index);
    }

    @Override
    public TopDocs getTopDocs() {
        return this.queryHits.getTopDocs();
    }
}

