/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.spi;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.search.cfg.spi.DirectoryProviderService;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.FSDirectoryProvider;
import org.hibernate.search.store.impl.FSMasterDirectoryProvider;
import org.hibernate.search.store.impl.FSSlaveDirectoryProvider;
import org.hibernate.search.store.impl.RAMDirectoryProvider;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class BaseDirectoryProviderService
implements DirectoryProviderService {
    private static final Log LOG = LoggerFactory.make();
    private static final String CONFIG_KEY = "directory_provider";
    protected final Map<String, String> defaultProviderClasses = new HashMap<String, String>(5);

    public BaseDirectoryProviderService() {
        this.defaultProviderClasses.put("filesystem", FSDirectoryProvider.class.getName());
        this.defaultProviderClasses.put("filesystem-master", FSMasterDirectoryProvider.class.getName());
        this.defaultProviderClasses.put("filesystem-slave", FSSlaveDirectoryProvider.class.getName());
        this.defaultProviderClasses.put("ram", RAMDirectoryProvider.class.getName());
        this.defaultProviderClasses.put("infinispan", "org.infinispan.hibernate.search.spi.InfinispanDirectoryProvider");
    }

    public DirectoryProvider create(Properties indexProps, String indexName, BuildContext context) {
        String className = indexProps.getProperty(CONFIG_KEY, "").trim();
        if (className.isEmpty()) {
            return this.initialize(this.getDefault().getName(), indexName, indexProps, context);
        }
        String fullClassName = this.toFullyQualifiedClassName(className);
        return this.initialize(fullClassName, indexName, indexProps, context);
    }

    protected DirectoryProvider<?> initialize(String fullClassName, String indexName, Properties indexProps, BuildContext context) {
        ServiceManager serviceManager = context.getServiceManager();
        DirectoryProvider provider = ClassLoaderHelper.instanceFromName(DirectoryProvider.class, fullClassName, "directory provider", serviceManager);
        try {
            provider.initialize(indexName, indexProps, context);
        }
        catch (Exception e) {
            throw LOG.cannotInitializeDirectoryProvider(provider.getClass(), indexName, e);
        }
        return provider;
    }
}

