/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.bytecode.enhancement;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.cfg.Environment;
import org.hibernate.testing.bytecode.enhancement.CustomEnhancementContext;
import org.hibernate.testing.bytecode.enhancement.EnhancerTestContext;
import org.hibernate.testing.junit4.CustomRunner;
import org.junit.runner.Runner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class BytecodeEnhancerRunner
extends Suite {
    private static final RunnerBuilder CUSTOM_RUNNER_BUILDER = new RunnerBuilder(){

        public Runner runnerForClass(Class<?> testClass) throws Throwable {
            return new CustomRunner(testClass);
        }
    };

    public BytecodeEnhancerRunner(Class<?> klass) throws ClassNotFoundException, InitializationError {
        super(CUSTOM_RUNNER_BUILDER, klass, (Class[])BytecodeEnhancerRunner.enhanceTestClass(klass));
    }

    private static Class<?>[] enhanceTestClass(Class<?> klass) throws ClassNotFoundException {
        String packageName = klass.getPackage().getName();
        ArrayList classList = new ArrayList();
        try {
            if (klass.isAnnotationPresent(CustomEnhancementContext.class)) {
                for (Class<? extends EnhancementContext> contextClass : klass.getAnnotation(CustomEnhancementContext.class).value()) {
                    EnhancementContext enhancementContextInstance = contextClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    classList.add(BytecodeEnhancerRunner.getEnhancerClassLoader(enhancementContextInstance, packageName).loadClass(klass.getName()));
                }
            } else {
                classList.add(BytecodeEnhancerRunner.getEnhancerClassLoader((EnhancementContext)new EnhancerTestContext(), packageName).loadClass(klass.getName()));
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return classList.toArray(new Class[0]);
    }

    private static ClassLoader getEnhancerClassLoader(final EnhancementContext context, final String packageName) {
        return new ClassLoader(){
            private final String debugOutputDir = System.getProperty("java.io.tmpdir");
            private final Enhancer enhancer = Environment.getBytecodeProvider().getEnhancer(context);

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                if (!name.startsWith(packageName)) {
                    return this.getParent().loadClass(name);
                }
                Class<?> c = this.findLoadedClass(name);
                if (c != null) {
                    return c;
                }
                try (InputStream is = this.getResourceAsStream(name.replace('.', '/') + ".class");){
                    if (is == null) {
                        throw new ClassNotFoundException(name + " not found");
                    }
                    byte[] original = new byte[is.available()];
                    Serializable serializable = null;
                    try (BufferedInputStream bis = new BufferedInputStream(is);){
                        bis.read(original);
                    }
                    catch (Throwable throwable) {
                        serializable = throwable;
                        throw throwable;
                    }
                    byte[] enhanced = this.enhancer.enhance(name, original);
                    if (enhanced == null) {
                        serializable = this.defineClass(name, original, 0, original.length);
                        return serializable;
                    }
                    File f = new File(this.debugOutputDir + File.separator + name.replace(".", File.separator) + ".class");
                    f.getParentFile().mkdirs();
                    f.createNewFile();
                    try (FileOutputStream out = new FileOutputStream(f);){
                        out.write(enhanced);
                    }
                    Class<?> clazz = this.defineClass(name, enhanced, 0, enhanced.length);
                    return clazz;
                }
                catch (Throwable t) {
                    throw new ClassNotFoundException(name + " not found", t);
                }
            }
        };
    }
}

