/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.schema;

import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.internal.build.AllowSysOut;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.Action;
import org.hibernate.tool.schema.spi.DelayedDropRegistry;
import org.hibernate.tool.schema.spi.DelayedDropRegistryNotAvailableImpl;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;

public class SchemaUpdateHelper {
    public static void update(Metadata metadata) {
        SchemaUpdateHelper.update(metadata, (ServiceRegistry)((MetadataImplementor)metadata).getMetadataBuildingOptions().getServiceRegistry());
    }

    public static void update(Metadata metadata, ServiceRegistry serviceRegistry) {
        Map settings = ((ConfigurationService)serviceRegistry.getService(ConfigurationService.class)).getSettings();
        settings.put("javax.persistence.schema-generation.database.action", Action.UPDATE);
        SchemaManagementToolCoordinator.process((Metadata)metadata, (ServiceRegistry)serviceRegistry, (Map)settings, (DelayedDropRegistry)DelayedDropRegistryNotAvailableImpl.INSTANCE);
    }

    @AllowSysOut
    public static void toStdout(Metadata metadata) {
        SchemaUpdateHelper.toWriter(metadata, new OutputStreamWriter(System.out));
    }

    public static void toWriter(Metadata metadata, Writer writer) {
        StandardServiceRegistry serviceRegistry = ((MetadataImplementor)metadata).getMetadataBuildingOptions().getServiceRegistry();
        Map settings = ((ConfigurationService)serviceRegistry.getService(ConfigurationService.class)).getSettings();
        settings.put("javax.persistence.schema-generation.scripts.action", Action.UPDATE);
        settings.put("javax.persistence.schema-generation.scripts.create-target", writer);
        SchemaManagementToolCoordinator.process((Metadata)metadata, (ServiceRegistry)serviceRegistry, (Map)settings, (DelayedDropRegistry)DelayedDropRegistryNotAvailableImpl.INSTANCE);
    }
}

