/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.web;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.basic.web.GeneratedToken;
import org.hswebframework.web.authorization.basic.web.ReactiveUserTokenGenerator;
import org.hswebframework.web.authorization.basic.web.ReactiveUserTokenParser;
import org.hswebframework.web.authorization.token.ParsedToken;
import org.hswebframework.web.id.IDGenerator;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class DefaultUserTokenGenPar
implements ReactiveUserTokenGenerator,
ReactiveUserTokenParser {
    private long timeout = TimeUnit.MINUTES.toMillis(30L);
    private String headerName = "X-Access-Token";

    @Override
    public String getTokenType() {
        return "default";
    }

    @Override
    public GeneratedToken generate(Authentication authentication) {
        final String token = (String)IDGenerator.MD5.generate();
        return new GeneratedToken(){

            @Override
            public Map<String, Object> getResponse() {
                return Collections.singletonMap("expires", DefaultUserTokenGenPar.this.timeout);
            }

            @Override
            public String getToken() {
                return token;
            }

            @Override
            public String getType() {
                return DefaultUserTokenGenPar.this.getTokenType();
            }

            @Override
            public long getTimeout() {
                return DefaultUserTokenGenPar.this.timeout;
            }
        };
    }

    @Override
    public Mono<ParsedToken> parseToken(ServerWebExchange exchange) {
        final String token = Optional.ofNullable(exchange.getRequest().getHeaders().getFirst(this.headerName)).orElseGet(() -> (String)exchange.getRequest().getQueryParams().getFirst((Object)":X_Access_Token"));
        if (token == null) {
            return Mono.empty();
        }
        return Mono.just((Object)new ParsedToken(){

            public String getToken() {
                return token;
            }

            public String getType() {
                return DefaultUserTokenGenPar.this.getTokenType();
            }
        });
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }
}

