/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.defaults.service;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.hswebframework.ezorm.core.StaticMethodReferenceColumn;
import org.hswebframework.ezorm.rdb.exception.DuplicateKeyException;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.hswebframework.web.event.AsyncEvent;
import org.hswebframework.web.exception.BusinessException;
import org.hswebframework.web.system.authorization.api.entity.DimensionUserEntity;
import org.hswebframework.web.system.authorization.api.event.ClearUserAuthorizationCacheEvent;
import org.hswebframework.web.system.authorization.api.event.DimensionBindEvent;
import org.hswebframework.web.system.authorization.api.event.DimensionUnbindEvent;
import org.hswebframework.web.system.authorization.api.event.UserDeletedEvent;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.function.Function3;

public class DefaultDimensionUserService
extends GenericReactiveCrudService<DimensionUserEntity, String> {
    private static final Logger log = LoggerFactory.getLogger(DefaultDimensionUserService.class);
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    @EventListener
    public void handleUserDeleteEntity(UserDeletedEvent event) {
        event.async((Publisher)((ReactiveDelete)this.createDelete().where(DimensionUserEntity::getUserId, (Object)event.getUser().getId())).execute().doOnSuccess(i -> log.debug("user deleted,clear user dimension!")));
    }

    public Mono<SaveResult> save(Publisher<DimensionUserEntity> entityPublisher) {
        return (Mono)this.publishEvent(entityPublisher, (Function3<String, String, List<String>, AsyncEvent>)((Function3)DimensionBindEvent::new)).as(x$0 -> super.save(x$0));
    }

    public Mono<Integer> updateById(String id, Mono<DimensionUserEntity> entityPublisher) {
        return (Mono)entityPublisher.doOnNext(entity -> this.eventPublisher.publishEvent((Object)ClearUserAuthorizationCacheEvent.of((String[])new String[]{entity.getUserId()}))).as(e -> super.updateById((Object)id, e));
    }

    public Mono<Integer> insert(Publisher<DimensionUserEntity> entityPublisher) {
        return ((Mono)this.publishEvent(entityPublisher, (Function3<String, String, List<String>, AsyncEvent>)((Function3)DimensionBindEvent::new)).as(x$0 -> super.insert(x$0))).onErrorMap(DuplicateKeyException.class, err -> new BusinessException("error.duplicate_key"));
    }

    public Mono<Integer> insertBatch(Publisher<? extends Collection<DimensionUserEntity>> entityPublisher) {
        Flux cache = Flux.from(entityPublisher).cache();
        return this.publishEvent((Publisher<DimensionUserEntity>)cache.flatMapIterable(Function.identity()), (Function3<String, String, List<String>, AsyncEvent>)((Function3)DimensionBindEvent::new)).then(super.insertBatch((Publisher)cache));
    }

    private Flux<DimensionUserEntity> publishEvent(Publisher<DimensionUserEntity> stream, Function3<String, String, List<String>, AsyncEvent> event) {
        Flux cache = Flux.from(stream).doOnNext(DimensionUserEntity::generateId).cache();
        return cache.groupBy(DimensionUserEntity::getDimensionTypeId).flatMap(typeGroup -> {
            String type = (String)typeGroup.key();
            return typeGroup.groupBy(DimensionUserEntity::getDimensionId).flatMap(dimensionIdGroup -> {
                String dimensionId = (String)dimensionIdGroup.key();
                return dimensionIdGroup.map(DimensionUserEntity::getUserId).collectList().flatMap(userIdList -> {
                    this.eventPublisher.publishEvent((Object)ClearUserAuthorizationCacheEvent.of((Collection)userIdList));
                    return ((AsyncEvent)event.apply((Object)type, (Object)dimensionId, userIdList)).publish(this.eventPublisher);
                });
            });
        }).thenMany((Publisher)cache);
    }

    public ReactiveUpdate<DimensionUserEntity> createUpdate() {
        return super.createUpdate().onExecute((update, r) -> r.flatMap(result -> ((ReactiveQuery)((ReactiveQuery)this.createQuery().select(new StaticMethodReferenceColumn[]{DimensionUserEntity::getUserId})).setParam(update.toQueryParam())).fetch().map(DimensionUserEntity::getUserId).distinct().collectList().map(ClearUserAuthorizationCacheEvent::of).doOnNext(arg_0 -> ((ApplicationEventPublisher)this.eventPublisher).publishEvent(arg_0)).thenReturn(result)));
    }

    public ReactiveDelete createDelete() {
        return super.createDelete().onExecute((delete, r) -> this.publishEvent((Publisher<DimensionUserEntity>)((ReactiveQuery)((ReactiveQuery)this.createQuery().select(new StaticMethodReferenceColumn[]{DimensionUserEntity::getUserId})).setParam(delete.toQueryParam())).fetch(), (Function3<String, String, List<String>, AsyncEvent>)((Function3)DimensionUnbindEvent::new)).then(r));
    }
}

