/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.defaults.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.Dimension;
import org.hswebframework.web.authorization.DimensionProvider;
import org.hswebframework.web.authorization.ReactiveAuthenticationInitializeService;
import org.hswebframework.web.authorization.User;
import org.hswebframework.web.authorization.access.DataAccessConfig;
import org.hswebframework.web.authorization.builder.DataAccessConfigBuilderFactory;
import org.hswebframework.web.authorization.simple.SimpleAuthentication;
import org.hswebframework.web.authorization.simple.SimplePermission;
import org.hswebframework.web.authorization.simple.SimpleUser;
import org.hswebframework.web.authorization.simple.builder.SimpleDataAccessConfigBuilderFactory;
import org.hswebframework.web.system.authorization.api.entity.AuthorizationSettingEntity;
import org.hswebframework.web.system.authorization.api.entity.ParentPermission;
import org.hswebframework.web.system.authorization.api.entity.PermissionEntity;
import org.hswebframework.web.system.authorization.api.entity.UserEntity;
import org.hswebframework.web.system.authorization.api.service.reactive.ReactiveUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultReactiveAuthenticationInitializeService
implements ReactiveAuthenticationInitializeService {
    private static final Logger log = LoggerFactory.getLogger(DefaultReactiveAuthenticationInitializeService.class);
    @Autowired
    private ReactiveUserService userService;
    @Autowired
    private ReactiveRepository<AuthorizationSettingEntity, String> settingRepository;
    @Autowired
    private ReactiveRepository<PermissionEntity, String> permissionRepository;
    @Autowired(required=false)
    private DataAccessConfigBuilderFactory builderFactory = new SimpleDataAccessConfigBuilderFactory();
    @Autowired(required=false)
    private List<DimensionProvider> dimensionProviders = new ArrayList<DimensionProvider>();

    public Mono<Authentication> initUserAuthorization(String userId) {
        return this.doInit((Mono<UserEntity>)this.userService.findById(userId));
    }

    public Mono<Authentication> doInit(Mono<UserEntity> userEntityMono) {
        return userEntityMono.flatMap(user -> {
            SimpleAuthentication authentication = new SimpleAuthentication();
            authentication.setUser((User)SimpleUser.builder().id(user.getId()).name(user.getName()).username(user.getUsername()).userType(user.getType()).build());
            return this.initPermission(authentication).switchIfEmpty(Mono.just((Object)authentication)).onErrorResume(err -> {
                log.warn(err.getMessage(), err);
                return Mono.just((Object)authentication);
            });
        });
    }

    protected Flux<AuthorizationSettingEntity> getSettings(List<Dimension> dimensions) {
        return Flux.fromIterable(dimensions).filter(dimension -> dimension.getType() != null).groupBy(d -> d.getType().getId(), Dimension::getId).flatMap(group -> group.collectList().flatMapMany(list -> ((ReactiveQuery)((ReactiveQuery)((ReactiveQuery)this.settingRepository.createQuery().where(AuthorizationSettingEntity::getState, (Object)1)).and(AuthorizationSettingEntity::getDimensionType, group.key())).in(AuthorizationSettingEntity::getDimensionTarget, (Collection)list)).fetch()));
    }

    protected Mono<Authentication> initPermission(SimpleAuthentication authentication) {
        return Flux.fromIterable(this.dimensionProviders).flatMap(provider -> provider.getDimensionByUserId(authentication.getUser().getId())).cast(Dimension.class).collectList().doOnNext(arg_0 -> ((SimpleAuthentication)authentication).setDimensions(arg_0)).flatMap(allDimension -> Mono.zip(this.getAllPermission(), (Mono)this.getSettings((List<Dimension>)allDimension).collect(Collectors.groupingBy(AuthorizationSettingEntity::getPermission)), (_p, _s) -> this.handlePermission(authentication, (List<Dimension>)allDimension, (Map<String, PermissionEntity>)_p, (Map<String, List<AuthorizationSettingEntity>>)_s)));
    }

    protected SimpleAuthentication handlePermission(SimpleAuthentication authentication, List<Dimension> dimensionList, Map<String, PermissionEntity> permissions, Map<String, List<AuthorizationSettingEntity>> settings) {
        HashMap<String, PermissionEntity> permissionMap = new HashMap<String, PermissionEntity>();
        HashMap<String, SimplePermission> allowed = new HashMap<String, SimplePermission>();
        try {
            for (PermissionEntity permissionEntity : permissions.values()) {
                permissionMap.put(permissionEntity.getId(), permissionEntity);
                List<AuthorizationSettingEntity> permissionSettings = settings.get(permissionEntity.getId());
                if (CollectionUtils.isEmpty(permissionSettings)) continue;
                permissionSettings.sort(Comparator.comparingInt(e -> e.getPriority() == null ? 0 : e.getPriority()));
                SimplePermission permission = new SimplePermission();
                permission.setId(permissionEntity.getId());
                permission.setName(permissionEntity.getName());
                permission.setOptions(permissionEntity.getProperties());
                HashSet configs = new HashSet();
                for (AuthorizationSettingEntity permissionSetting : permissionSettings) {
                    boolean merge = Boolean.TRUE.equals(permissionSetting.getMerge());
                    if (!merge) {
                        permission.getActions().clear();
                    }
                    if (permissionSetting.getDataAccesses() != null) {
                        permissionSetting.getDataAccesses().stream().map(conf -> {
                            DataAccessConfig config = this.builderFactory.create().fromMap(conf.toMap()).build();
                            if (config == null) {
                                log.warn("unsupported data access:{}", (Object)conf.toMap());
                            }
                            return config;
                        }).filter(Objects::nonNull).forEach(configs::add);
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)permissionSetting.getActions())) continue;
                    permission.getActions().addAll(permissionSetting.getActions());
                }
                allowed.put(permissionEntity.getId(), permission);
                permission.setDataAccesses(configs);
            }
            for (PermissionEntity permissionEntity : permissions.values()) {
                SimplePermission allow = (SimplePermission)allowed.get(permissionEntity.getId());
                if (allow == null || CollectionUtils.isEmpty((Collection)permissionEntity.getParents())) continue;
                for (ParentPermission parent : permissionEntity.getParents()) {
                    PermissionEntity mergePermission;
                    Set pre;
                    if (StringUtils.isEmpty((Object)parent.getPermission()) || !CollectionUtils.isEmpty((Collection)(pre = parent.getPreActions())) && !allow.getActions().containsAll(pre) || (mergePermission = (PermissionEntity)permissionMap.get(parent.getPermission())) == null) continue;
                    SimplePermission merge = (SimplePermission)allowed.get(parent.getPermission());
                    if (merge == null) {
                        merge = new SimplePermission();
                        merge.setName(mergePermission.getName());
                        merge.setId(mergePermission.getId());
                        allowed.put(merge.getId(), merge);
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)parent.getActions())) continue;
                    merge.getActions().addAll(parent.getActions());
                }
            }
            authentication.setPermissions(new ArrayList(allowed.values()));
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        return authentication;
    }

    protected Mono<Map<String, PermissionEntity>> getAllPermission() {
        return ((ReactiveQuery)this.permissionRepository.createQuery().where(PermissionEntity::getStatus, (Object)1)).fetch().collect(Collectors.toMap(PermissionEntity::getId, Function.identity())).switchIfEmpty(Mono.just(Collections.emptyMap()));
    }
}

