/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.defaults.webflux;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.List;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.DeleteAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.hswebframework.web.system.authorization.api.entity.DimensionUserEntity;
import org.hswebframework.web.system.authorization.defaults.service.DefaultDimensionUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/dimension-user"})
@Authorize
@Resource(id="dimension", name="\u6743\u9650\u7ef4\u5ea6\u7ba1\u7406", group={"system"})
@Tag(name="\u6743\u9650\u7ef4\u5ea6\u7528\u6237\u5173\u8054\u7ba1\u7406")
public class WebFluxDimensionUserController
implements ReactiveServiceCrudController<DimensionUserEntity, String> {
    @Autowired
    private DefaultDimensionUserService dimensionUserService;

    public ReactiveCrudService<DimensionUserEntity, String> getService() {
        return this.dimensionUserService;
    }

    @DeleteAction
    @DeleteMapping(value={"/user/{userId}/dimension/{dimensionId}"})
    @Operation(summary="\u89e3\u9664\u7528\u6237\u5173\u8054\u7684\u6307\u5b9a\u7ef4\u5ea6")
    public Mono<Integer> deleteByUserAndDimensionId(@PathVariable @Parameter(description="\u7528\u6237ID") String userId, @PathVariable @Parameter(description="\u7ef4\u5ea6ID") String dimensionId) {
        return ((ReactiveDelete)((ReactiveDelete)this.dimensionUserService.createDelete().where(DimensionUserEntity::getUserId, (Object)userId)).and(DimensionUserEntity::getDimensionId, (Object)dimensionId)).execute();
    }

    @DeleteAction
    @DeleteMapping(value={"/user/{userId}"})
    @Operation(summary="\u89e3\u9664\u7528\u6237\u5173\u8054\u7684\u5168\u90e8\u7ef4\u5ea6")
    public Mono<Integer> deleteByUserId(@PathVariable @Parameter(description="\u7528\u6237ID") String userId) {
        return ((ReactiveDelete)this.dimensionUserService.createDelete().where(DimensionUserEntity::getUserId, (Object)userId)).execute();
    }

    @DeleteAction
    @DeleteMapping(value={"/dimension/{dimensionId}"})
    @Operation(summary="\u89e3\u9664\u5168\u90e8\u7528\u6237\u5173\u8054\u7684\u6307\u5b9a\u7ef4\u5ea6")
    public Mono<Integer> deleteByDimension(@PathVariable @Parameter(description="\u7ef4\u5ea6ID") String dimensionId) {
        return ((ReactiveDelete)this.dimensionUserService.createDelete().where(DimensionUserEntity::getDimensionId, (Object)dimensionId)).execute();
    }

    @DeleteAction
    @PostMapping(value={"/user/{dimensionType}/{dimensionId}/_unbind"})
    @Operation(summary="\u89e3\u9664\u7528\u6237\u5173\u8054\u7684\u6307\u5b9a\u7ef4\u5ea6")
    public Mono<Integer> deleteUserDimension(@PathVariable @Parameter(description="\u7ef4\u5ea6\u7c7b\u578b,\u6bd4\u5982: role") String dimensionType, @PathVariable @Parameter(description="\u7ef4\u5ea6ID,\u6bd4\u5982: \u89d2\u8272ID") String dimensionId, @Parameter(description="\u7528\u6237ID") @RequestBody Mono<List<String>> userId) {
        return userId.flatMap(userIdList -> ((ReactiveDelete)((ReactiveDelete)((ReactiveDelete)this.dimensionUserService.createDelete().where(DimensionUserEntity::getDimensionId, (Object)dimensionId)).and(DimensionUserEntity::getDimensionTypeId, (Object)dimensionType)).in(DimensionUserEntity::getUserId, (Collection)userIdList)).execute());
    }
}

