/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit;

import org.jboss.arquillian.junit.State;
import org.jboss.arquillian.test.spi.LifecycleMethodExecutor;
import org.jboss.arquillian.test.spi.TestRunnerAdaptor;
import org.jboss.arquillian.test.spi.TestRunnerAdaptorBuilder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ArquillianTestClass
implements TestRule {
    private TestRunnerAdaptor adaptor;

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                State.runnerStarted();
                if (!State.hasTestAdaptor()) {
                    if (State.hasInitializationException()) {
                        throw new RuntimeException("Arquillian initialization has already been attempted, but failed. See previous exceptions for cause", State.getInitializationException());
                    }
                    try {
                        TestRunnerAdaptor adaptor = TestRunnerAdaptorBuilder.build();
                        adaptor.beforeSuite();
                        State.testAdaptor(adaptor);
                    }
                    catch (Exception e) {
                        State.caughtInitializationException(e);
                        State.runnerFinished();
                        if (State.isLastRunner()) {
                            State.clean();
                        }
                        throw e;
                    }
                }
                if (State.hasTestAdaptor()) {
                    ArquillianTestClass.this.adaptor = State.getTestAdaptor();
                }
                ArquillianTestClass.this.adaptor.beforeClass(description.getTestClass(), LifecycleMethodExecutor.NO_OP);
                try {
                    base.evaluate();
                }
                finally {
                    ArquillianTestClass.this.adaptor.afterClass(description.getTestClass(), LifecycleMethodExecutor.NO_OP);
                    State.runnerFinished();
                    if (State.isLastRunner()) {
                        try {
                            ArquillianTestClass.this.adaptor.afterSuite();
                            ArquillianTestClass.this.adaptor.shutdown();
                        }
                        finally {
                            State.clean();
                        }
                    }
                    ArquillianTestClass.this.adaptor = null;
                }
            }
        };
    }
}

