/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

class URLPattern {
    private String pattern;
    private String ext;
    private int length;
    private PatternType type;

    URLPattern(String pattern) {
        this.pattern = pattern;
        this.length = pattern.length();
        if (pattern.equals("/")) {
            this.type = PatternType.DEFAULT;
        } else if (pattern.startsWith("/*")) {
            this.type = PatternType.THE_PATH_PREFIX;
        } else if (this.length > 0 && pattern.charAt(0) == '/' && pattern.endsWith("/*")) {
            this.type = PatternType.PATH_PREFIX;
        } else if (pattern.startsWith("*.")) {
            this.type = PatternType.EXTENSION;
            this.ext = pattern.substring(1);
        } else {
            this.type = PatternType.EXACT;
        }
    }

    boolean matches(URLPattern url) {
        return this.matches(url.pattern);
    }

    boolean matches(String urlPattern) {
        if (this.type == PatternType.DEFAULT || this.type == PatternType.THE_PATH_PREFIX) {
            return true;
        }
        if (this.type == PatternType.EXTENSION && urlPattern.endsWith(this.ext)) {
            return true;
        }
        if (this.type == PatternType.PATH_PREFIX) {
            if (urlPattern.regionMatches(0, this.pattern, 0, this.length - 2)) {
                int last = this.length - 2;
                return urlPattern.length() <= last || urlPattern.charAt(last) == '/';
            }
            return false;
        }
        return this.pattern.equals(urlPattern);
    }

    String getPattern() {
        return this.pattern;
    }

    boolean isDefault() {
        return this.type == PatternType.DEFAULT;
    }

    boolean isExact() {
        return this.type == PatternType.EXACT;
    }

    boolean isExtension() {
        return this.type == PatternType.EXTENSION;
    }

    boolean isPrefix() {
        return this.type == PatternType.THE_PATH_PREFIX || this.type == PatternType.PATH_PREFIX;
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object o) {
        boolean equals;
        if (!(o instanceof URLPattern)) {
            return false;
        }
        URLPattern pattern = (URLPattern)o;
        boolean bl = equals = this.type == pattern.type;
        if (equals) {
            equals = this.pattern.equals(pattern.pattern);
        }
        return equals;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PatternType {
        DEFAULT,
        THE_PATH_PREFIX,
        PATH_PREFIX,
        EXTENSION,
        EXACT;

    }
}

